function setCookie(cname, cvalue, exdays) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function checkCookie(cname) {
    let name = getCookie(cname);
    if (name != "") {
        return true;
    } else {
        return false;
    }
}

function eraseCookie(name) {
    document.cookie = name + '=; Max-Age=-99999999;';
}

jQuery(document).ready(function ($) {

    // const $$ = content.document.querySelectorAll;

    $("#ms-container")
        .parent("#wpbody-content")
        .parent("#wpbody")
        .parent("#wpcontent")
        .parent("#wpwrap")
        .parent("body")
        .css({
            "background-color": "#fff",
            "margin": "0",
            "font-size": "1rem",
            "font-weight": "400"
        });

    $("#widgetBlk").sortable({
        axis: 'y',
        update: function (event, ui) {
            let data = $(this).sortable('serialize');
            let value = data.split("&");
            console.log(value);
            /*$.ajax({
                    data: oData,
                type: 'POST',
                url: '/your/url/here'
            });*/
        }
    });


    $("#addModalOpen").click(function () {
        /**
         * open modal add widget
         */
        $("#addModal").iziModal();

        /**
         * open modal widget add link
         */
        $("#modalOpenLink").click(function () {

            if (!checkCookie('addLink')) {
                setCookie('addLink', 1, 365);
            }

            $("#modal_link").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });

        /**
         * open modal widget add contact us
         */
        $("#modalOpenContact").click(function () {


            if (!checkCookie('addContact')) {
                setCookie('addContact', 1, 365);
            }

            $("#modal_contact").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });

        /**
         * open modal widget add contact us
         */
        $("#modalOpenMessage").click(function () {

            if (!checkCookie('addMessage')) {
                setCookie('addMessage', 1, 365);
            }

            $("#modal_messenger").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });


        /**
         * open modal widget add description
         */
        $("#modalOpenText").click(function () {

            if (!checkCookie('addText')) {
                setCookie('addText', 1, 365);
            }

            $("#modal_text").iziModal();

            /**
             * transform label input
             */
            modal_text("#modal-body textarea");
            modal_body("#modal-body input");
        });

        /**
         * open modal widget quickShop
         */
        $("#modalOpenShop").click(function () {

            if (!checkCookie('addShop')) {
                setCookie('addShop', 1, 365);
            }

            $("#modal_shop").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });

        /**
         * open modal widget eNamad
         */
        $("#modalOpenEnamad").click(function () {

            if (!checkCookie('eNamad')) {
                setCookie('eNamad', 1, 365);
            }

            $("#modal_eNamad").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });


        /**
         * open modal widget addMap
         */
        $("#modalOpenAddMap").click(function () {

            if (!checkCookie('addMap')) {
                setCookie('addMap', 1, 365);
            }

            $("#modal_map").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });

        /**
         * open modal widget addFaq
         */
        $("#modalOpenAddFaq").click(function () {

            if (!checkCookie('addFaq')) {
                setCookie('addFaq', 1, 365);
            }

            $("#modal_faq").iziModal();

            /**
             * transform label input
             */
            modal_body("#modal-body input");

        });
    });

    function modal_body(id) {
        $(id).focus(function () {
            $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
        }).blur(function () {
            var inputValue = $(this).val();
            if (inputValue) {
                return inputValue;
            } else {
                $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
            }
        });
    }

    function modal_text(id) {
        $(id).focus(function () {
            let $label =  $("label[for='" + this.id + "']");
            $label.css("transform", "scale(1) translateY(-25px)");
            $label.css("font-size", "12px");
        }).blur(function () {
            let inputValue = $(this).val();
            if (inputValue) {
                return inputValue;
            } else {
                $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
            }
        });
    }

    $("#submit-zlink input").focus(function () {
        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
    }).blur(function () {
        let inputValue = $(this).val();
        if (inputValue) {
            return inputValue;
        } else {
            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
        }
    });

    $("input[name='name']").focus(function () {
        $("#getUrl").hide();
    }).blur(function () {
        let inputValue = $(this).val();
        if (inputValue) {
            return inputValue;
        } else {
            $("#getUrl").show();
        }
    });

    // $("#avatars").change(function () {
    //     let reader = new FileReader();
    //     reader.onload = function (e) {
    //         $("#preview").attr('src', e.target.result);
    //     }
    //     reader.readAsDataURL(this.files[0]);
    // });
});







