<?php


class iLink_zlink
{
    /**
     * @var null
     */
    private static $_instance = null;

    /**
     * @var $uploadedFile ;
     */
    public $uploadedFile;

    /**
     * iLink_zlink constructor.
     */
    public function __construct()
    {
        /**
         * add action save ajax data to database
         */
        add_action('wp_ajax_addMainLink', array($this, 'addMainLink'));
        add_action('wp_ajax_nopriv_addMainLink', array($this, 'addMainLink'));
        /**
         * add action file upload
         */
        add_action('wp_ajax_file_upload', array($this, 'file_upload_callback'));
        add_action('wp_ajax_nopriv_file_upload', array($this, 'file_upload_callback'));
        /**
         * add action check page not exist
         */
        add_action('wp_ajax_chkPage', array($this, 'chkPage_callback'));
        add_action('wp_ajax_nopriv_chkPage', array($this, 'chkPage_callback'));
        /**
         * add action edit zlink
         */
        add_action('wp_ajax_editMainLink', array($this, 'editMainLink_callback'));
        add_action('wp_ajax_nopriv_editMainLink', array($this, 'editMainLink_callback'));
        /**
         * add action edit file upload
         */
        add_action('wp_ajax_edit_file_upload', array($this, 'edit_file_upload_callback'));
        add_action('wp_ajax_nopriv_edit_file_upload', array($this, 'edit_file_upload_callback'));
        /**
         * add action delete Link
         */
        add_action('wp_ajax_dltLink', array($this, 'dltLink_callback'));
        add_action('wp_ajax_nopriv_dltLink', array($this, 'dltLink_callback'));
    }

    /**
     * instance from class
     * @return iLink_zlink|null
     */
    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * add data to table zlink
     */
    public function addMainLink()
    {
        global $wpdb, $name, $title, $subtitle, $uploadedFile, $src_avatars;

        $zlink_links = $wpdb->prefix . "zlink_links";

        if (isset($_SESSION['upload'])) $uploadedFile = $_SESSION['upload'];

        if (isset($_POST['name']) && !empty($_POST['name'])) $name = $_POST['name'];
        if (isset($_POST['title']) && !empty($_POST['title'])) $title = $_POST['title'];
        if (isset($_POST['subtitle']) && !empty($_POST['subtitle'])) $subtitle = $_POST['subtitle'];
        if (isset($_POST['src_avatars']) && !empty($_POST['src_avatars'])) $src_avatars = $_POST['src_avatars'];

        $data = array(
            'id_page' => null,
            'link_name' => $name,
            'title' => $title,
            'subtitle' => $subtitle,
            'images' => $src_avatars
        );

        $result = $wpdb->insert($zlink_links, $data);
        $lastId = $wpdb->insert_id;

        $pgLink = [
            'post_title' => $title,
            'post_name' => $name,
            'post_content' => "[zlink id=" . $lastId . "]",
            'post_status' => 'publish',
            'post_author' => get_current_user_id(),
            'post_type' => 'page',
            'page_template' => 'template-zlink.php'
        ];

        $idPageZlink = wp_insert_post($pgLink);
        $resUpdate = $wpdb->update($zlink_links, ['id_page' => $idPageZlink], ['ID' => $lastId]);
        $urlRedirect = sprintf('admin.php?page=zlink/editLink.php&id=%s&zlink=%s', $lastId, $idPageZlink);

//            $urlRedirect = add_query_arg(
//                array(
//                    'page' => 'zlink/editLink.php',
//                    'id' => $lastId,
//                    'zlink' => $idPageZlink
//                ),
//                admin_url()
//            );

        if ($result && $resUpdate) {
            $_SESSION['alert'] = true;
            wp_send_json_success([
                'redirect' => $urlRedirect
            ]);
        }

        wp_send_json_error([
            'error' => $wpdb->show_errors()
        ]);

    }

    /**
     * upload file with ajax
     */
    public function file_upload_callback()
    {
        global $mediaFile;

        if (isset($_FILES['file']) && is_array($_FILES['file'])) {
            $mediaFile = $_FILES['file'];
        }

        $upload_data = array(
            'name' => ZLI_NAM[0] . '-' . time() . '-' . $mediaFile['name'],
            'type' => $mediaFile['type'],
            'tmp_name' => $mediaFile['tmp_name'],
            'error' => $mediaFile['error'],
            'size' => $mediaFile['size']
        );

        $uploadedFile = wp_handle_upload($upload_data, array('test_form' => false));

        $_SESSION['upload'] = $uploadedFile;

        wp_send_json(['upload' => $uploadedFile]);
    }

    /**
     * check exist page return true and false
     */
    public function chkPage_callback()
    {
        global $pageName, $result;
        if (isset($_POST['name']) && !empty($_POST['name'])) $pageName = $_POST['name'];

        $page = get_page_by_title($pageName, OBJECT);
        $slug = get_page_by_path($pageName, OBJECT);

        if (is_null($page) && is_null($slug)) $result = true; else $result = false;

        wp_send_json(['result' => $result]);
    }

    /**
     * edit main link zlink
     */
    public function editMainLink_callback()
    {
        global $wpdb, $name, $title, $subtitle, $linkID, $src_avatars;
        $zlink_links = $wpdb->prefix . "zlink_links";

        if (isset($_POST['linkID']) && !empty($_POST['linkID'])) $linkID = $_POST['linkID'];

        $link_table = $wpdb->get_results("SELECT * FROM {$zlink_links} WHERE `id` = {$linkID}", OBJECT);

        if (isset($_POST['name']) && !empty($_POST['name'])) $name = $_POST['name'];
        if (isset($_POST['title']) && !empty($_POST['title'])) $title = $_POST['title'];
        if (isset($_POST['subtitle']) && !empty($_POST['subtitle'])) $subtitle = $_POST['subtitle'];
        if (isset($_POST['src_avatars']) && !empty($_POST['src_avatars'])) $src_avatars = $_POST['src_avatars'];

        $data_now = array(
            'link_name' => $link_table[0]->link_name,
            'title' => $link_table[0]->title,
            'subtitle' => $link_table[0]->subtitle,
            'images' => $link_table[0]->images
        );

        $data = array(
            'link_name' => $name,
            'title' => $title,
            'subtitle' => $subtitle,
            'images' => $src_avatars
        );

        if ($data_now == $data) {
            $result = 3;
            $urlRedirect = sprintf('admin.php?page=zlink/dashboard.php&status=%s', $result);
            wp_send_json(['redirect' => $urlRedirect]);
            exit();
        }

        $result = $wpdb->update($zlink_links, $data, ['id' => $linkID]);
        $urlRedirect = sprintf('admin.php?page=zlink/dashboard.php&status=%s', $result);

        $pgLink = [
            'ID' => $link_table[0]->id_page,
            'post_title' => $title,
            'post_name' => $name,
        ];

        wp_update_post($pgLink);

        if ($result) {
            wp_send_json(['redirect' => $urlRedirect]);
        } else {
            $wpdb->print_error();
        }

    }

    /**
     * edit file upload callback
     */
    public function edit_file_upload_callback()
    {
        global $wpdb, $File, $EditUploaded, $linkID;
        $zlink_links = $wpdb->prefix . "zlink_links";

        if (isset($_POST['linkID']) && !empty($_POST['linkID'])) $linkID = $_POST['linkID'];
        if (isset($_FILES['file']) && is_array($_FILES['file'])) {
            $File = $_FILES['file'];
        }

        $upload_data = array(
            'name' => ZLI_NAM[0] . '-' . time() . '-' . $File['name'],
            'type' => $File['type'],
            'tmp_name' => $File['tmp_name'],
            'error' => $File['error'],
            'size' => $File['size']
        );

        $EditUploaded = wp_handle_upload($upload_data, array('test_form' => false));

        $data = array(
            'images' => $EditUploaded['url']
        );

        $result = $wpdb->update($zlink_links, $data, ['id' => $linkID]);
        wp_send_json(['upload' => $result]);
    }

    /**
     * delete link callback
     */
    public function dltLink_callback()
    {
        global $wpdb, $linkID, $linkIDPage;

        $zlink_links = $wpdb->prefix . "zlink_links";

        if (isset($_POST['linkID']) && !empty($_POST['linkID'])) $linkID = $_POST['linkID'];
        if (isset($_POST['linkIDPage']) && !empty($_POST['linkIDPage'])) $linkIDPage = $_POST['linkIDPage'];

        $result = $wpdb->delete($zlink_links, ['id' => $linkID]);
        $page = wp_delete_post($linkIDPage, true);
        wp_delete_post($linkIDPage, true);

        wp_send_json(['result' => $result, 'page' => $page]);
    }


    public static function dd($data)
    {
        echo '<pre style="direction: ltr;text-align: left;">';
        var_dump($data);
        echo '</pre>';
        die();
    }
}

iLink_zlink::instance();