<?php global $wpdb; ?>
<div id="ms-container" class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div id="form-zlink" class="main">
                <h3><?= __('Add link', 'zlink') ?></h3>
                <hr>
                <form id="submit-zlink" name="insert" action="#" method="post"
                      enctype="multipart/form-data">
                    <input type="hidden" name="action" value="addMainLink">
                    <div id="add-form" class="add-form form-group">
                        <div class="icon">
                            <i class="fa fa-users"></i>
                        </div>
                        <label class="label-name" for="name"><?= __('ID zlink', 'zlink') ?></label>
                        <input id="name" class="form-control" type="text" name="name" maxlength="255" size="60">
                        <small id="getUrl"><?= backend::url() ?></small>
                        <span id="addSmallName"
                              class="add-small description text-muted"><?= __('For example mostafa or dominodev', 'zlink') ?></span>
                    </div>
                    <hr>
                    <div class="upload-avatar">
                        <div class="row">
                            <div class="col-md-7">
                                <div class="upload-zlink">
                                    <input name="avatars" id="avatars" class="upload" required="" type="file"
                                           accept="image/*"
                                           hidden/>
                                    <input type="hidden" name="src_avatars" id="src_avatars">
                                    <label for="avatars"><?= __('Upload zlink image ', 'zlink') ?></label>
                                </div>
                                <small id="addSmallFile" class="text-avatar">
                                    <?= __('You can get an image or a logo Choose for your Xylink. Files must be smaller than 8 MB. Authorized file types: png gif jpg jpeg.', 'zlink') ?>
                                </small>
                            </div>
                            <div class="col-md-5">
                                <div class="upload-picture">
                                    <img id="preview" src="<?= ZLI_URL . 'assets/images/avatars.png' ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="add-title" class="title-form form-group">
                        <div class="icon">
                            <i class="fa fa-user"></i>
                        </div>
                        <label class="label-title" for="title"><?= __('Name / Title ', 'zlink') ?></label>
                        <input id="title" class="form-control" type="text" name="title" maxlength="255" size="60">
                        <small id="addSmallTitle" class="description text-muted">
                            <?= __('For example, Nazanin Ahmadi, Vobkaran Company or @mostafa ', 'zlink') ?>
                        </small>
                    </div>

                    <div id="add-subtitle" class="subtitle-form form-group">
                        <div class="icon">
                            <i class="fa fa-user"></i>
                        </div>
                        <label class="label-subtitle" for="subtitle"><?= __('Sub-headings', 'zlink') ?></label>
                        <input id="subtitle" class="form-control" type="text" name="subtitle" maxlength="255"
                               size="60">
                        <small id="addSmallSubtitle" class="description text-muted">
                            <?= __('For example, Calais Digital Manager, web developer', 'zlink') ?>
                        </small>
                    </div>

                    <button id="submit" type="submit" class="btn btn-success btn-lg add-btn">
                        <span class="btn-loading" style="display: none;">
                                <i class="fas fa-spinner fa-spin"></i>
                        </span>
                        <?= __('Save', 'zlink') ?>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    (function ($) {
        $(document).ready(function () {
            $("#submit-zlink").validate({
                rules: {
                    name: {
                        required: true
                    },
                    title: {
                        required: true
                    },
                    subtitle: {
                        required: true
                    }
                },
                messages: {
                    name: "<?= __('Please enter the name of your link', 'zlink') ?>",
                    title: "<?= __('Please enter the title of your link', 'zlink') ?>",
                    subtitle: "<?= __('Please enter your subtitle', 'zlink') ?>"
                },
                errorPlacement: function (error, element) {
                    switch (element.attr("name")) {
                        case "name" :
                            error.insertAfter("#addSmallName");
                            $("#add-form").children(".icon").css("height", "47%");
                            $("#add-form").children("#getUrl").css("bottom", "50%");
                            $("#add-form").children(".error").css("padding-right", "30px");
                            $("#add-form label").css("top", "10%");
                            break;
                        case "title" :
                            error.insertAfter("#addSmallTitle");
                            $("#add-title").children(".icon").css("height", "45%");
                            $("#add-title label").css("top", "10%");
                            break;
                        case "subtitle" :
                            error.insertAfter("#addSmallSubtitle");
                            $("#add-subtitle").children(".icon").css("height", "45%");
                            $("#add-subtitle").css("top", "10%");
                            break;
                    }
                },
                submitHandler: function () {
                    return true
                },
                errorElement: 'span'
            });

            $('input[name^="avatars"]').rules('add', {
                required: true,
                accept: "image/jpeg, image/pjpeg"
            });
        });

        $(document).on('submit', '#submit-zlink', function (event) {
            event.preventDefault();
            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: ajax.ajax_url,
                data: $(this).serialize(),
                success: function (res) {
                    if (res.success) {
                        window.location.href = res.data.redirect;
                    }

                }
            });
        });

        $(document).on('click', '#avatars', function (event) {
            event.preventDefault();
            let image = wp.media({
                title: "<?= __('Upload Images', 'zlink') ?>",
                multiple: false
            }).open()
                .on('select', function (e) {
                    let uploaded_image = image.state().get('selection').first();
                    let image_url = uploaded_image.toJSON().url;
                    $('#src_avatars').val(image_url);
                    $('#preview').attr('src', image_url);
                });
        });

        $(document).on('change', '#name', function () {
            let name = $(this).val();
            let formData = new FormData();
            formData.append('name', name);
            formData.append('action', 'chkPage');
            $.ajax({
                url: ajax.ajax_url,
                type: 'POST',
                contentType: false,
                processData: false,
                data: formData,
                success: function (response) {
                    let result = response.result;
                    if (result) {
                        $("#submit").attr('disabled', false);
                        $("#name").removeClass('border-error');
                    } else {
                        $("#submit").attr('disabled', true);
                        $("#name").addClass('border-error');
                        $("#add-form").children(".icon").css("height", "65%");
                        iziToast.error({
                            id: 'error',
                            class: 'ms-error',
                            title: "<?= __('please pay attention!', 'zlink') ?>",
                            message: "<?= __('The name chosen for the duplicate link', 'zlink') ?>",
                            progressBar: false,
                            timeout: false,
                            rtl: true,
                            position: 'topRight',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            transitionIn: 'flipInX',
                            transitionOut: 'flipOutX'
                        });
                    }
                }
            });

        });

    })(jQuery)
</script>


