<?php
global $wpdb, $editZlink;
$zlink_links = $wpdb->prefix . "zlink_links";
$links = $wpdb->get_results("SELECT * FROM {$zlink_links}", ARRAY_A);
?>

<div id="ms-container" class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="ms-title-dashboard">
                <i class="fa fa-dashboard"></i>
                <h2><?= __('zlink', 'zlink') ?></h2>
            </div>
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-link"></i>
                    <h4><?= __('links', 'zlink') ?></h4>
                </div>
                <?php if (edit_widget_init()) { ?>
                    <div class="card-body">
                        <div class="row ms-card-box">
                            <?php
                            if (!empty($links)) :
                            foreach ($links as $link) :
                                ?>
                                <div class="col-md-4">
                                    <div class="ms-box">
                                        <div id="loading-<?= $link['ID'] ?>" class="zlink-loading"
                                             style="display: none;">
                                            <i class="fas fa-spinner fa-spin"></i>
                                        </div>
                                        <div class="ms-img">
                                            <?php if (backend::isValidUrl($link['images'])) { ?>
                                                <img src="<?= $link['images'] ?>">
                                            <?php } else { ?>
                                                <img src="<?= ZLI_URL . 'assets/images/avatars.png' ?>">
                                            <?php } ?>
                                        </div>
                                        <div class="ms-body">
                                            <div class="ms-title">
                                                <?= $link['title'] ?>
                                            </div>
                                            <div class="ms-description">
                                                <?= $link['subtitle'] ?>
                                            </div>
                                        </div>
                                        <div class="ms-footer">
                                            <?php $urlEdit = sprintf('admin.php?page=zlink/edit.php&id=%s', $link['ID']); ?>
                                            <a href="<?= $urlEdit ?>" class="btn ms-btn-edit">
                                                <i class="fa fa-pencil"></i>
                                            </a>

                                            <?php $urlRedirect = sprintf('admin.php?page=zlink/editLink.php&id=%s', $link['ID']); ?>
                                            <a href="<?= $urlRedirect ?>" class="btn ms-btn">
                                                <i class="fa fa-tools"></i>
                                            </a>

                                            <button id="dltLink-<?= $link['ID'] ?>" type="button"
                                                    class="btn ms-btn ms-btn-danger">
                                                <i class="fa fa-trash"></i>
                                            </button>

                                            <?php $urlView = backend::url() . $link['link_name'] ?>
                                            <a id="dlt-link" href="<?= $urlView ?>"
                                               class="btn ms-btn ms-btn-primary"
                                               target="_blank">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <script>
                                    (function ($) {
                                        $("#dltLink-<?= $link['ID'] ?>").on("click", function () {
                                            let linkID = <?= $link['ID'] ?>;
                                            let linkIDPage = <?= $link['id_page'] ?>;
                                            let form_data = new FormData();
                                            form_data.append('linkID', linkID);
                                            form_data.append('linkIDPage', linkIDPage);
                                            form_data.append('action', 'dltLink');
                                            iziToast.question({
                                                rtl: true,
                                                layout: 1,
                                                drag: false,
                                                timeout: false,
                                                close: false,
                                                overlay: true,
                                                displayMode: 1,
                                                id: 'question',
                                                class: 'ms-question',
                                                progressBar: true,
                                                title: "<?= __('Delete', 'zlink') ?>",
                                                message: "<?= __('Are you sure?', 'zlink') ?>",
                                                position: 'center',
                                                buttons: [
                                                    ['<button><b><?= __('Yes', 'zlink') ?></b></button>', function (instance, toast) {
                                                        $.ajax({
                                                            url: ajax.ajax_url,
                                                            type: 'POST',
                                                            contentType: false,
                                                            processData: false,
                                                            data: form_data,
                                                            beforeSend: function () {
                                                                $('#loading-<?= $link['ID'] ?>').show();
                                                            },
                                                            success: function (res) {
                                                                if (res.result) {
                                                                    iziToast.success({
                                                                        id: 'success',
                                                                        class: 'ms-error',
                                                                        title: "<?= __('Delete', 'zlink') ?>",
                                                                        message: "<?= __('Link removed successfully', 'zlink') ?>",
                                                                        progressBar: true,
                                                                        timeout: 1500,
                                                                        rtl: true,
                                                                        position: 'topRight',
                                                                        overlay: false,
                                                                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                                        transitionIn: 'flipInX',
                                                                        transitionOut: 'flipOutX',
                                                                    });
                                                                }
                                                            },
                                                            complete: function () {
                                                                $('#loading-<?= $link['ID'] ?>').hide();
                                                                location.reload();
                                                            }
                                                        });
                                                        instance.hide({
                                                            transitionOut: 'fadeOut'
                                                        }, toast, 'button');
                                                    }, false],
                                                    ['<button><b><?= __('No', 'zlink') ?></b></button>', function (instance, toast) {
                                                        instance.hide({
                                                            transitionOut: 'fadeOut'
                                                        }, toast, 'button');
                                                    }, false],
                                                ]
                                            });
                                        });
                                    })(jQuery)
                                </script>
                            <?php endforeach;
                            else : ?>
                                <div class="col-md-12">
                                    <div class="alert alert-warning" role="alert">
                                        <?= __('Create your first link', 'zlink') ?>
                                        <a href="<?= admin_url('admin.php?page=zlink%2Fadd.php') ?>">
                                            <strong><?= __('Create links', 'zlink') ?></strong>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php } else { ?>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <i class="fa fa-info-circle"></i>
                            <?= __('To use Zlink features, please enter the product license', 'zlink') ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<script>
    (function ($) {
        $(document).ready(function () {
            <?php if (isset($_GET['status'])) : ?>
            let editZlink = <?= $_GET['status'] ?>;
            if (editZlink) {
                iziToast.success({
                    id: 'success',
                    class: 'ms-error',
                    title: "<?= __('Edit', 'zlink') ?>",
                    message: "<?= __('Editing completed successfully', 'zlink') ?>",
                    progressBar: true,
                    timeout: 5000,
                    rtl: true,
                    position: 'topRight',
                    overlay: false,
                    overlayColor: 'rgba(0, 0, 0, 0.7)',
                    transitionIn: 'flipInX',
                    transitionOut: 'flipOutX'
                });
                <?php unset($_GET['status']); ?>
            } else {
                iziToast.error({
                    id: 'error',
                    class: 'ms-error',
                    title: "<?= __('Edit', 'zlink') ?>",
                    message: "<?= __('Editing encountered an error, please try again', 'zlink') ?>",
                    progressBar: true,
                    timeout: 5000,
                    rtl: true,
                    position: 'topRight',
                    overlay: false,
                    overlayColor: 'rgba(0, 0, 0, 0.7)',
                    transitionIn: 'flipInX',
                    transitionOut: 'flipOutX'
                });
                <?php unset($_GET['status']); ?>
            }
            <?php endif; ?>
        });
    })(jQuery)
</script>





