<?php

global $wpdb, $randID;
global $idWidget;

if (isset($_SESSION['alert'])) {
    echo "
  <script>
  iziToast.show({
            class: 'alertSuccess',
            title: 'موفق',
            message: 'لینک با موفقیت اضافه گردید',
            rtl: true,
            pauseOnHover: true,
            backgroundColor: 'rgba(166,239,184,.9)',
            position: 'topLeft',
        });
  </script>";
}

global $idPageZlink;
global $lastId;
$zlink_links = $wpdb->prefix . "zlink_links";
$zlink_widget = $wpdb->prefix . "zlink_widget";
$zlink_neshan = $wpdb->prefix . "zlink_neshan";
if (isset($_GET['id'])) $lastId = $_GET['id'];
if (isset($_GET['zlink'])) $idPageZlink = $_GET['zlink'];

$link_table = $wpdb->get_results("SELECT * FROM {$zlink_links} WHERE `id` = {$lastId}", ARRAY_A);

$widget_table = $wpdb->get_results("SELECT * FROM {$zlink_widget} WHERE `link_id` = {$lastId} ORDER BY `ID` ASC", ARRAY_A);

if (isset($_GET['idWidget'])) {
    $urlBack = sprintf('admin.php?page=%s&id=%s&zlink=%s', $_REQUEST['page'], $lastId, $idPageZlink);
    wp_redirect($urlBack);
    $wpdb->delete($zlink_widget, ['ID' => $_GET['idWidget']]);
    unset($_GET['idWidget']);
}

$product_categories = get_terms(array(
    'taxonomy' => 'product_cat',
    'hide_empty' => true,
));

$terms = get_terms('product_tag');

$numProducts = [2, 4, 6, 8];

$rowProducts = [
    1 => 12,
    2 => 6
];

global $apiID;
if (isset($_SESSION['apiID'])) {
    $apiID = $_SESSION['apiID'];
}

if (!is_null($apiID)) {
    $api_table = $wpdb->get_results("SELECT * FROM {$zlink_neshan} WHERE `ID` = {$apiID} ORDER BY `ID` ASC", ARRAY_A);
} else {
    $api_table = $wpdb->get_results("SELECT * FROM {$zlink_neshan}", ARRAY_A);
}


$apikey = isset($api_table[0]['apiNeshan']) ? $api_table[0]['apiNeshan'] : '';

function hasShortcode($value)
{
    $search = ['[', ']'];
    $shortcode = str_replace($search, '', $value);
    $shortcode_array = explode(' ', $shortcode);
    return has_shortcode('[' . $shortcode_array[0] . ']', $shortcode_array[0]);
}

function show_shortcode($value)
{
    $search = ['\"', '\"'];
    $shortcode = str_replace($search, '"', $value);
    return do_shortcode($shortcode);
}

global $widget, $content, $numid;
$numid = isset($_SESSION['randID']) && !empty($_SESSION['randID']) ? $_SESSION['randID'] : '';

?>
<div id="ms-container" class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-4 node__content">
            <div class="notch"></div>
            <div class="device">
                <div id="editLink">
                    <div class="upload-picture">
                        <?php if (backend::isValidUrl($link_table[0]['images']) && !empty($link_table[0]['images'])) { ?>
                            <img src="<?= $link_table[0]['images'] ?>">
                        <?php } else { ?>
                            <img src="<?= ZLI_URL . 'assets/images/avatars.png' ?>">
                        <?php } ?>
                    </div>
                    <div class="title">
                        <h4><?= $link_table[0]['title'] ?></h4>
                    </div>
                    <div class="description">
                        <p><?= $link_table[0]['subtitle'] ?></p>
                    </div>
                    <div id="list-zlink" class="list-zlink">
                        <div id="widgetBlk" class="row field">
                            <?php if (!empty($widget_table)) : ?>
                            <?php foreach ($widget_table

                            as $widget) : ?>
                            <?php $widget_unique = $widget['ID']; ?>
                            <?php
                            /**
                             * widget link
                             */
                            if ($widget['widget_name'] == 'Link') {
                                $content = json_decode($widget['content'], true);
                                $widgetId = "addLink_widget_" . $widget['ID'];
                                $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);
                                ?>
                                <div id="addLink_widget_<?= $widget['ID'] ?>" class="ms-widget-link">
                                    <h4 class="col-12 text-center">
                                        <div class="title-link">
                                            <?= $widgetTitle = $content['widgetTitle'] ? $content['widgetTitle'] : __('Useful links', 'zlink'); ?>
                                        </div>
                                    </h4>
                                    <div class="col-12 link">
                                        <div class="field__item">
                                            <i class="fa fa-external-link"></i>
                                            <a target="_blank" href="<?= $content['url'] ?>">
                                                <?= $content['titleLink'] ?>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-12 btn-remove">
                                        <a id="editBlkLink_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widget['ID']; ?>"
                                           class="btn btn-outline-success btn-sm"
                                           data-izimodal-open="#edit_modal_link_<?= $widget['ID'] ?>"
                                           data-izimodal-transitionin="fadeInDown">
                                            <i class="fa fa-pencil"></i>
                                        </a>

                                        <a id="removeBlkLink_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </div>

                                <script>
                                    (function ($) {
                                        // Open Modal Edit Link
                                        let modalID = "#edit_modal_link_" + <?= $widget['ID'] ?>;
                                        let modalInput = "#eFrmLink_" + <?= $widget['ID'] ?> + " #modal-body input";
                                        $("#editBlkLink_" + <?= $widget['ID'] ?>).click(function () {
                                            $(modalID).iziModal({
                                                overlayClose: false,
                                                onOpening: function () {
                                                    let inputValue = $(modalInput);
                                                    if (inputValue.value) {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }
                                                    inputValue.focus(function () {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }).blur(function () {
                                                        if (inputValue.val()) {
                                                            return inputValue.val();
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }
                                            });
                                        });

                                        $("#removeBlkLink_<?= $widget['ID'] ?>").click(function () {
                                            const widgetRandID = getCookie('addLink') - 1;
                                            setCookie('addLink', widgetRandID, 365);
                                            window.location.href = "<?= $urlDelete ?>";
                                        });

                                        /**
                                         * edit ajax data widget link in database
                                         */
                                        $(document).on('submit', '#eFrmLink_<?= $widget['ID'] ?>', function (event) {
                                            event.preventDefault();
                                            $.ajax({
                                                type: "POST",
                                                dataType: "JSON",
                                                url: ajax.ajax_url,
                                                data: $(this).serialize(),
                                                beforeSend: function () {
                                                    $(modalID).iziModal('close');
                                                    iziToast.show({
                                                        class: 'ms-progress',
                                                        title: "<?= __('please wait', 'zlink') ?>",
                                                        message: "<?= __('Editing the widget', 'zlink') ?>",
                                                        messageSize: '16px',
                                                        messageLineHeight: '1.8rem',
                                                        titleSize: '18px',
                                                        titleLineHeight: '1.8rem',
                                                        pauseOnHover: true,
                                                        close: false,
                                                        rtl: true,
                                                        position: 'topRight',
                                                        progressBar: true,
                                                        progressBarColor: 'rgb(2, 127, 27)',
                                                        progressBarEasing: 'linear',
                                                        overlay: true,
                                                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                        backgroundColor: '#d6ffde'
                                                    });
                                                },
                                                success: function (response) {
                                                    location.reload();
                                                }
                                            });
                                        });
                                    })(jQuery)
                                </script>

                                <?php
                                // edit widget editAddLink
                                require(ZLI_PAG . 'widgets/edit/editAddLink.php');

                            }
                            /**
                             * widget contact
                             */
                            if ($widget['widget_name'] == 'contactUs') {
                                $content = json_decode($widget['content'], true);
                                $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);
                                ?>
                                <div id="addLink_widget_<?= $widget['ID'] ?>" class="ms-widget-link">
                                    <h4 class="col-12 text-center">
                                        <div class="title-link">
                                            <?= $content['widgetTitle'] ? $content['widgetTitle'] : __('contactUs', 'zlink'); ?>
                                        </div>
                                    </h4>
                                    <?php if ($content['phone']) : ?>
                                        <div class="col-12 link">
                                            <div class="field__item">
                                                <i class="fa fa-mobile"></i>
                                                <a target="_blank"
                                                   href="tel:<?= $content['phone'] ?>"><?= $content['phone'] ?></a>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($content['telephone']) : ?>
                                        <div class="col-12 link">
                                            <div class="field__item">
                                                <i class="fa fa-phone"></i>
                                                <a target="_blank"
                                                   href="tel:<?= $content['telephone'] ?>"><?= $content['telephone'] ?></a>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($content['email']) : ?>
                                        <div class="col-12 link">
                                            <div class="field__item">
                                                <i class="fa fa-envelope"></i>
                                                <a target="_blank"
                                                   href=mailto:"<?= $content['email'] ?>"><?= $content['email'] ?></a>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($content['fax']) : ?>
                                        <div class="col-12 link">
                                            <div class="field__item">
                                                <i class="fa fa-fax"></i>
                                                <a target="_blank"
                                                   href="tel:<?= $content['fax'] ?>"><?= $content['fax'] ?></a>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-12 btn-remove">
                                        <a id="editBlkContact_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widget['ID']; ?>"
                                           class="btn btn-outline-success btn-sm"
                                           data-izimodal-open="#edit_modal_contact_<?= $widget['ID'] ?>"
                                           data-izimodal-transitionin="fadeInDown">
                                            <i class="fa fa-pencil"></i>
                                        </a>

                                        <a id="removeBlkContact_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </div>

                                <script>
                                    (function ($) {
                                        // Open Modal Edit Contact
                                        let modalID = "#edit_modal_contact_" + <?= $widget['ID'] ?>;
                                        let modalInput = "#eFrmContact_" + <?= $widget['ID'] ?> + " #modal-body input";
                                        $("#editBlkContact_" + <?= $widget['ID'] ?>).click(function () {
                                            $(modalID).iziModal({
                                                overlayClose: false,
                                                onOpening: function () {
                                                    let inputValue = $(modalInput);
                                                    inputValue.focus(function () {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }).blur(function () {
                                                        if (inputValue.val()) {
                                                            return inputValue.val();
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }
                                            });
                                        });

                                        $("#removeBlkContact_<?= $widget['ID'] ?>").click(function () {
                                            const widgetRandID = getCookie('addContact') - 1;
                                            setCookie('addContact', widgetRandID, 365);
                                            window.location.href = "<?= $urlDelete ?>";
                                        });

                                        /**
                                         * edit ajax data widget contact in database
                                         */
                                        $(document).on('submit', '#eFrmContact_<?= $widget['ID'] ?>', function (event) {
                                            event.preventDefault();
                                            $.ajax({
                                                type: "POST",
                                                dataType: "JSON",
                                                url: ajax.ajax_url,
                                                data: $(this).serialize(),
                                                beforeSend: function () {
                                                    $(modalID).iziModal('close');
                                                    iziToast.show({
                                                        class: 'ms-progress',
                                                        title: "<?= __('please wait', 'zlink') ?>",
                                                        message: "<?= __('Editing the contact widget ...', 'zlink') ?>",
                                                        messageSize: '16px',
                                                        messageLineHeight: '1.8rem',
                                                        titleSize: '18px',
                                                        titleLineHeight: '1.8rem',
                                                        pauseOnHover: true,
                                                        close: false,
                                                        rtl: true,
                                                        position: 'topRight',
                                                        progressBar: true,
                                                        progressBarColor: 'rgb(2, 127, 27)',
                                                        progressBarEasing: 'linear',
                                                        overlay: true,
                                                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                        backgroundColor: '#d6ffde'
                                                    });
                                                },
                                                success: function (response) {
                                                    location.reload();
                                                }
                                            });
                                        });
                                    })(jQuery)
                                </script>
                                <?php
                                // edit widget editAddLink
                                require(ZLI_PAG . 'widgets/edit/editContactUs.php');
                            }
                            /**
                             * widget message
                             */
                            if ($widget['widget_name'] == 'Message') {
                                $content = json_decode($widget['content'], true);
                                $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);
                                ?>
                                <div id="addMessage_widget_<?= $widget['ID'] ?>" class="ms-widget-link">
                                    <h4 class="col-12 text-center">
                                        <div class="title-link">
                                            <?= $content['widgetTitle'] ? $content['widgetTitle'] : __('Messenger', 'zlink'); ?>
                                        </div>
                                    </h4>

                                    <div class="row align-items-center">
                                        <?php if ($content['telegram']) : ?>
                                            <div class="col-6 link ms-message ms-telegram">
                                                <div class="field__item">
                                                    <a target="_blank"
                                                       href="tg://resolve?domain=@<?= $content['telegram'] ?>">
                                                        <i class="fa fa-mobile"></i>
                                                        <?= __('Telegram', 'zlink') ?>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <?php if ($content['whatsapp']) : ?>
                                            <div class="col-6 link ms-message ms-whatsapp">
                                                <div class="field__item">
                                                    <a target="_blank"
                                                       href="https://api.whatsapp.com/send?phone=<?= $content['whatsapp'] ?>">
                                                        <i class="fa fa-mobile"></i>
                                                        <?= __('whatsapp', 'zlink') ?>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-12 btn-remove">
                                        <a id="editBlkMessage_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widget['ID']; ?>"
                                           class="btn btn-outline-success btn-sm"
                                           data-izimodal-open="#edit_modal_message_<?= $widget['ID'] ?>"
                                           data-izimodal-transitionin="fadeInDown">
                                            <i class="fa fa-pencil"></i>
                                        </a>

                                        <a id="removeBlkMessage_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </div>

                                <script>
                                    (function ($) {
                                        // Open Modal Edit Message
                                        let modalID = "#edit_modal_message_" + <?= $widget['ID'] ?>;
                                        let modalInput = "#eFrmMessage_" + <?= $widget['ID'] ?> + " #modal-body input";
                                        $("#editBlkMessage_" + <?= $widget['ID'] ?>).click(function () {
                                            $(modalID).iziModal({
                                                overlayClose: false,
                                                onOpening: function () {
                                                    let inputValue = $(modalInput);
                                                    inputValue.focus(function () {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }).blur(function () {
                                                        if (inputValue.val()) {
                                                            return inputValue.val();
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }
                                            });
                                        });

                                        $("#removeBlkMessage_<?= $widget['ID'] ?>").click(function () {
                                            let widgetRandID = getCookie('addMessage') - 1;
                                            setCookie('addMessage', widgetRandID, 365);
                                            window.location.href = "<?= $urlDelete ?>";
                                        });

                                        /**
                                         * edit ajax data widget Message in database
                                         */
                                        $(document).on('submit', '#eFrmMessage_<?= $widget['ID'] ?>', function (event) {
                                            event.preventDefault();
                                            $.ajax({
                                                type: "POST",
                                                dataType: "JSON",
                                                url: ajax.ajax_url,
                                                data: $(this).serialize(),
                                                beforeSend: function () {
                                                    $(modalID).iziModal('close');
                                                    iziToast.show({
                                                        class: 'ms-progress',
                                                        title: "<?= __('please wait', 'zlink') ?>",
                                                        message: "<?= __('Editing messenger widget ...', 'zlink') ?>",
                                                        messageSize: '16px',
                                                        messageLineHeight: '1.8rem',
                                                        titleSize: '18px',
                                                        titleLineHeight: '1.8rem',
                                                        pauseOnHover: true,
                                                        close: false,
                                                        rtl: true,
                                                        position: 'topRight',
                                                        progressBar: true,
                                                        progressBarColor: 'rgb(2, 127, 27)',
                                                        progressBarEasing: 'linear',
                                                        overlay: true,
                                                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                        backgroundColor: '#d6ffde'
                                                    });
                                                },
                                                success: function (response) {
                                                    location.reload();
                                                }
                                            });
                                        });
                                    })(jQuery)
                                </script>
                                <?php
                                // edit widget Message
                                require(ZLI_PAG . 'widgets/edit/editMessenger.php');
                            }
                            /**
                             * widget addText
                             */
                            if ($widget['widget_name'] == 'Description') {
                                $content = json_decode($widget['content'], true);
                                $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);
                                ?>
                                <div id="addText_widget_<?= $widget['ID'] ?>" class="ms-widget-link">
                                    <h4 class="col-12 text-center">
                                        <div class="title-link">
                                            <?= $content['widgetTitle'] ? $content['widgetTitle'] : __('Description', 'zlink'); ?>
                                        </div>
                                    </h4>

                                    <div class="row align-items-center">
                                        <div class="col-12 link">
                                            <div class="field__item addWidgetText">
                                                <?php if (hasShortcode($content['text'])) { ?>
                                                    <?= show_shortcode($content['text']) ?>
                                                <?php } else { ?>
                                                    <p><?= $content['text'] ?></p>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 btn-remove">
                                        <a id="editBlkText_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widget['ID']; ?>"
                                           class="btn btn-outline-success btn-sm"
                                           data-izimodal-open="#edit_modal_text_<?= $widget['ID'] ?>"
                                           data-izimodal-transitionin="fadeInDown">
                                            <i class="fa fa-pencil"></i>
                                        </a>

                                        <a id="removeBlkText_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </div>

                                <script>
                                    (function ($) {
                                        // Open Modal Edit addText
                                        let modalID = "#edit_modal_text_" + <?= $widget['ID'] ?>;
                                        let modalInput = "#eFrmText_" + <?= $widget['ID'] ?> + " #modal-body input";

                                        $("#editBlkText_" + <?= $widget['ID'] ?>).click(function () {
                                            $(modalID).iziModal({
                                                overlayClose: false,
                                                onOpening: function () {
                                                    let inputValue = $(modalInput);
                                                    inputValue.focus(function () {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }).blur(function () {
                                                        if (inputValue.val()) {
                                                            return inputValue.val();
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }
                                            });
                                        });

                                        $("#removeBlkText_<?= $widget['ID'] ?>").click(function () {
                                            const widgetRandID = getCookie('addText') - 1;
                                            setCookie('addText', widgetRandID, 365);
                                            window.location.href = "<?= $urlDelete ?>";
                                        });

                                        /**
                                         * edit ajax data widget text in database
                                         */
                                        $(document).on('submit', '#eFrmText_<?= $widget['ID'] ?>', function (event) {
                                            event.preventDefault();
                                            $.ajax({
                                                type: "POST",
                                                dataType: "JSON",
                                                url: ajax.ajax_url,
                                                data: $(this).serialize(),
                                                beforeSend: function () {
                                                    $(modalID).iziModal('close');
                                                    iziToast.show({
                                                        class: 'ms-progress',
                                                        title: "<?= __('please wait', 'zlink') ?>",
                                                        message: "<?= __('Editing text widget / description ...', 'zlink') ?>",
                                                        messageSize: '16px',
                                                        messageLineHeight: '1.8rem',
                                                        titleSize: '18px',
                                                        titleLineHeight: '1.8rem',
                                                        pauseOnHover: true,
                                                        close: false,
                                                        rtl: true,
                                                        position: 'topRight',
                                                        progressBar: true,
                                                        progressBarColor: 'rgb(2, 127, 27)',
                                                        progressBarEasing: 'linear',
                                                        overlay: true,
                                                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                        backgroundColor: '#d6ffde'
                                                    });
                                                },
                                                success: function (response) {
                                                    location.reload();
                                                }
                                            });
                                        });
                                    })(jQuery)
                                </script>

                                <?php
                                // edit widget addText
                                require(ZLI_PAG . 'widgets/edit/editAddText.php');
                            }

                            /**
                             * widget addQuickShop
                             */
                            if ($widget['widget_name'] == 'quickShop') {
                            $content = json_decode($widget['content'], true);
                            $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);

                            $query = array(
                                'post_type' => 'product',
                                'post_status' => 'publish',
                                'ignore_sticky_posts' => 1,
                                'posts_per_page' => 6,
                                'no_found_rows' => true,
                                'meta_query' => [],
                                'tax_query' => [],
                                'order' => 'ASC'
                            );

                            if (!isset($content['productTag']) && empty($content['productTag'])) {
                                $query['tax_query'] = [
                                    'relation' => 'AND',
                                    array(
                                        'taxonomy' => 'product_cat',
                                        'field' => 'term_id',
                                        'terms' => $content['category'],
                                        'operator' => 'IN',
                                    )
                                ];
                            } else {
                                $query['tax_query'] = [
                                    'relation' => 'AND',
                                    array(
                                        'taxonomy' => 'product_cat',
                                        'field' => 'term_id',
                                        'terms' => $content['category']
                                    ),
                                    array(
                                        'taxonomy' => 'product_tag',
                                        'field' => 'term_id',
                                        'terms' => $content['productTag'],
                                        'operator' => 'IN',
                                    )
                                ];
                            }


                            if ($content['countProduct']) {
                                $query['posts_per_page'] = $content['countProduct'];
                            }

                            $wp_product = new \WP_Query($query);

                            ?>
                            <div id="addShop_widget_<?= $widget['ID'] ?>" class="ms-widget-link">

                                <h4 class="col-12 text-center">
                                    <div class="title-link">
                                        <?= $content['titleShop'] ?>
                                    </div>
                                </h4>

                                <div class="row align-items-center">
                                    <?php
                                    if ($wp_product->have_posts()) {
                                    while ($wp_product->have_posts()) :
                                    $wp_product->the_post();
                                    $products = new \WC_Product(get_the_ID());
                                    $regular_price = $products->get_regular_price();
                                    $sale_price = $products->get_sale_price();
                                    $stock_status = $products->get_stock_status();
                                    ?>
                                    <?php if ($content['numProduct'] != "") { ?>
                                    <div class="col-<?= intval($content['numProduct']) ?> ms-product">
                                        <?php } else { ?>
                                        <div class="col-6 ms-product">
                                            <?php } ?>
                                            <?php if ($stock_status === 'instock'): ?>
                                                <a class="link-shop"
                                                   href="<?= backend::url() . 'cart/?add-to-cart=' . $products->get_id() ?>"></a>
                                            <?php else: ?>
                                                <a class="link-shop"
                                                   href="<?= $products->get_permalink() ?>"></a>
                                            <?php endif; ?>
                                            <div class="quick-shop">
                                                <div class="img-shop">
                                                    <?= $products->get_image(); ?>
                                                </div>
                                                <div class="title-pro-shop">
                                                    <h5>
                                                        <?= $products->get_title(); ?>
                                                    </h5>
                                                    <?php if ($stock_status === 'instock'): ?>
                                                        <div class="price-shop">
                                                            <?= $products->get_price_html(); ?>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="price-shop outstock-shop">
                                                            <p><?= __('unavailable', 'zlink') ?></p>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if ($stock_status === 'instock'): ?>
                                                    <div id="btn-basket-shop" class="btn-basket-shop">
                                                        <a href="<?= backend::url() . 'cart/?add-to-cart=' . $products->get_id() ?>"
                                                           class="btn btn-outline-success">
                                                            <i class="fa fa-basket-shopping"></i>
                                                            <?= __('Add to cart', 'zlink') ?>
                                                        </a>
                                                    </div>
                                                <?php else: ?>
                                                    <div id="btn-basket-shop" class="btn-basket-shop">
                                                        <a href="<?= $products->get_permalink() ?>"
                                                           class="btn btn-outline-success">
                                                            <i class="fa fa-eye"></i>
                                                            <?= __('View product', 'zlink') ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <?php
                                        endwhile;
                                        wp_reset_postdata();
                                        }
                                        ?>
                                    </div>

                                    <div class="col-12 btn-remove">
                                        <a id="editBlkShop_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widget['ID']; ?>"
                                           class="btn btn-outline-success btn-sm"
                                           data-izimodal-open="#edit_modal_shop_<?= $widget['ID'] ?>"
                                           data-izimodal-transitionin="fadeInDown">
                                            <i class="fa fa-pencil"></i>
                                        </a>

                                        <a id="removeBlkShop_<?= $widget['ID'] ?>"
                                           data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </div>

                                <script>
                                    (function ($) {
                                        // Open Modal Edit addText
                                        let modalID = "#edit_modal_shop_" + <?= $widget['ID'] ?>;
                                        let modalInput = "#eFrmShop_" + <?= $widget['ID'] ?> + " #modal-body input";

                                        $("#editBlkShop_<?= $widget['ID'] ?>").click(function () {
                                            $(modalID).iziModal({
                                                overlayClose: false,
                                                onOpening: function () {
                                                    let inputValue = $(modalInput);
                                                    inputValue.focus(function () {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }).blur(function () {
                                                        if (inputValue.val()) {
                                                            return inputValue.val();
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }
                                            });
                                        });

                                        $("#removeBlkShop_<?= $widget['ID'] ?>").click(function () {
                                            if (getCookie('addShop') > 0) {
                                                const widgetRandID = getCookie('addShop') - 1;
                                                setCookie('addShop', widgetRandID, 365);
                                            }
                                            window.location.href = "<?= $urlDelete ?>";
                                        });

                                        /**
                                         * edit ajax data widget shop in database
                                         */
                                        $(document).on('submit', '#eFrmShop_<?= $widget['ID'] ?>', function (event) {
                                            event.preventDefault();
                                            $.ajax({
                                                type: "POST",
                                                dataType: "JSON",
                                                url: ajax.ajax_url,
                                                data: $(this).serialize(),
                                                beforeSend: function () {
                                                    $(modalID).iziModal('close');
                                                    iziToast.show({
                                                        class: 'ms-progress',
                                                        title: "<?= __('please wait', 'zlink') ?>",
                                                        message: "<?= __('Editing shop widget ...', 'zlink') ?>",
                                                        messageSize: '16px',
                                                        messageLineHeight: '1.8rem',
                                                        titleSize: '18px',
                                                        titleLineHeight: '1.8rem',
                                                        pauseOnHover: true,
                                                        close: false,
                                                        rtl: true,
                                                        position: 'topRight',
                                                        progressBar: true,
                                                        progressBarColor: 'rgb(2, 127, 27)',
                                                        progressBarEasing: 'linear',
                                                        overlay: true,
                                                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                        backgroundColor: '#d6ffde'
                                                    });
                                                },
                                                success: function (response) {
                                                    location.reload();
                                                }
                                            });
                                        });
                                    })(jQuery)
                                </script>

                                <?php
                                // edit widget QuickShop
                                require(ZLI_PAG . 'widgets/edit/editQuickShop.php');
                                }
                                /**
                                 * widget addEnamad
                                 */
                                if ($widget['widget_name'] == 'eNamad') {
                                    $content = json_decode($widget['content'], true);
                                    $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);

                                    ?>
                                    <div id="addEnamad_widget_<?= $widget['ID'] ?>" class="ms-widget-link">

                                        <h4 class="col-12 text-center">
                                            <div class="title-link"><?= __('eNamad', 'zlink') ?></div>
                                        </h4>

                                        <div class="row align-items-center">
                                            <div class="col-12 link">
                                                <div class="field__item addWidgetText enamad">
                                                    <a href="<?= $content['eNamadUrl'] ?>" target="_blank">
                                                        <img src="<?= ZLI_URL . 'assets/images/enamad_icon.png' ?>">
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="col-12 btn-remove">
                                                <a id="editBlkEnamad_<?= $widget['ID'] ?>"
                                                   data-widget="<?= $widget['ID']; ?>"
                                                   class="btn btn-outline-success btn-sm"
                                                   data-izimodal-open="#edit_modal_enamad_<?= $widget['ID'] ?>"
                                                   data-izimodal-transitionin="fadeInDown">
                                                    <i class="fa fa-pencil"></i>
                                                </a>

                                                <a id="removeBlkEnamad_<?= $widget['ID'] ?>"
                                                   data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                    <script>
                                        (function ($) {
                                            // Open Modal Edit addEnamad
                                            let modalID = "#edit_modal_enamad_" + <?= $widget['ID'] ?>;
                                            let modalInput = "#eFrmEnamad_" + <?= $widget['ID'] ?> + " #modal-body input";

                                            $("#editBlkEnamad_<?= $widget['ID'] ?>").click(function () {
                                                $(modalID).iziModal({
                                                    overlayClose: false,
                                                    onOpening: function () {
                                                        let inputValue = $(modalInput);
                                                        inputValue.focus(function () {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                        }).blur(function () {
                                                            if (inputValue.val()) {
                                                                return inputValue.val();
                                                            } else {
                                                                $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                            }
                                                        });
                                                    }
                                                });
                                            });

                                            $("#removeBlkEnamad_<?= $widget['ID'] ?>").click(function () {
                                                if (getCookie('addShop') > 0) {
                                                    const widgetRandID = getCookie('addShop') - 1;
                                                    setCookie('addShop', widgetRandID, 365);
                                                }
                                                window.location.href = "<?= $urlDelete ?>";
                                            });

                                            /**
                                             * edit ajax data widget enamad in database
                                             */
                                            $(document).on('submit', '#efrmEnamad_<?= $widget['ID'] ?>', function (event) {
                                                event.preventDefault();
                                                $.ajax({
                                                    type: "POST",
                                                    dataType: "JSON",
                                                    url: ajax.ajax_url,
                                                    data: $(this).serialize(),
                                                    beforeSend: function () {
                                                        $(modalID).iziModal('close');
                                                        iziToast.show({
                                                            class: 'ms-progress',
                                                            title: "<?= __('please wait', 'zlink') ?>",
                                                            message: "<?= __('Editing eNamad widget ...', 'zlink') ?>",
                                                            messageSize: '16px',
                                                            messageLineHeight: '1.8rem',
                                                            titleSize: '18px',
                                                            titleLineHeight: '1.8rem',
                                                            pauseOnHover: true,
                                                            close: false,
                                                            rtl: true,
                                                            position: 'topRight',
                                                            progressBar: true,
                                                            progressBarColor: 'rgb(2, 127, 27)',
                                                            progressBarEasing: 'linear',
                                                            overlay: true,
                                                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                            backgroundColor: '#d6ffde'
                                                        });
                                                    },
                                                    success: function (response) {
                                                        location.reload();
                                                    }
                                                });
                                            });
                                        })(jQuery)
                                    </script>

                                    <?php
                                    // edit widget eNamad
                                    require(ZLI_PAG . 'widgets/edit/editEnamad.php');
                                }
                                /**
                                 * widget addMap
                                 */
                                if ($widget['widget_name'] == 'Map') {
                                    $content = json_decode($widget['content'], true);
                                    $widgetId = "addMap_widget_" . $widget['ID'];
                                    $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);
                                    ?>
                                    <div id="addLink_widget_<?= $widget['ID'] ?>" class="ms-widget-link">
                                        <h4 class="col-12 text-center">
                                            <div class="title-link">
                                                <?= $content['titleMap'] ?>
                                            </div>
                                        </h4>
                                        <?php if ($apikey) { ?>
                                        <div class="col-12 link widgetMap">
                                            <div class="map" id="map_<?= $widget['ID'] ?>"
                                                 style="width: 100%; height: <?= $content['heightStyleMap'] ?>px;"></div>

                                            <a target="_blank" href="<?= $content['urlMap'] ?>"
                                               class="btn btn-outline-success btn-block">
                                                <i class="fa fa-map-location-dot"></i>
                                                <?= __('Direction', 'zlink') ?>
                                            </a>
                                            <script type="text/javascript">
                                                var myMap = new ol.Map({
                                                    target: "map_<?= $widget['ID'] ?>",
                                                    key: "<?= $apikey ?>",
                                                    maptype: 'dreamy',
                                                    poi: true,
                                                    traffic: true,
                                                    view: new ol.View({
                                                        center: ol.proj.fromLonLat([
                                                            <?= $content['heightMap'] ?>,
                                                            <?= $content['widthMap'] ?>
                                                        ]),
                                                        zoom: <?= $content['zoomMap'] ?>
                                                    })
                                                });

                                                myMap.setMapType("neshan");
                                            </script>
                                            <?php } else { ?>
                                                <div class="alert alert-warning is-dismissible mt-2">
                                                    <i class="fa fa-info-circle"></i>
                                                    <?= __('Please enter the Neshan key', 'zlink') ?>
                                                </div>
                                            <?php } ?>
                                        </div>

                                        <div class="col-12 btn-remove">
                                            <a id="editBlkMap_<?= $widget['ID'] ?>"
                                               data-widget="<?= $widget['ID']; ?>"
                                               class="btn btn-outline-success btn-sm"
                                               data-izimodal-open="#edit_modal_Map_<?= $widget['ID'] ?>"
                                               data-izimodal-transitionin="fadeInDown">
                                                <i class="fa fa-pencil"></i>
                                            </a>

                                            <a id="removeBlkMap_<?= $widget['ID'] ?>"
                                               data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        </div>
                                    </div>

                                    <script>
                                        (function ($) {
                                            $("#ms-container")
                                                .parent("#wpbody-content")
                                                .parent("#wpbody")
                                                .parent("#wpcontent")
                                                .parent("#wpwrap")
                                                .parent("body")
                                                .css({
                                                    "background-color": "#fff",
                                                    "margin": "0",
                                                    "font-size": "1rem",
                                                    "font-weight": "400"
                                                });


                                            // Open Modal Edit Map
                                            let modalID = "#edit_modal_Map_" + <?= $widget['ID'] ?>;
                                            let modalInput = "#eFrmMap_" + <?= $widget['ID'] ?> + " #modal-body input";
                                            $("#editBlkMap_" + <?= $widget['ID'] ?>).click(function () {
                                                $(modalID).iziModal({
                                                    overlayClose: false,
                                                    onOpening: function () {
                                                        let inputValue = $(modalInput);
                                                        if (inputValue.value) {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                        }
                                                        inputValue.focus(function () {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                        }).blur(function () {
                                                            if (inputValue.val()) {
                                                                return inputValue.val();
                                                            } else {
                                                                $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                            }
                                                        });
                                                    }
                                                });
                                            });

                                            $("#removeBlkMap_<?= $widget['ID'] ?>").click(function () {
                                                const widgetRandID = getCookie('addMap') - 1;
                                                setCookie('addMap', widgetRandID, 365);
                                                window.location.href = "<?= $urlDelete ?>";
                                            });


                                            /**
                                             * edit ajax data widget map in database
                                             */
                                            $(document).on('submit', '#eFrmMap_<?= $widget['ID'] ?>', function (event) {
                                                event.preventDefault();
                                                $.ajax({
                                                    type: "POST",
                                                    dataType: "JSON",
                                                    url: ajax.ajax_url,
                                                    data: $(this).serialize(),
                                                    beforeSend: function () {
                                                        $(modalID).iziModal('close');
                                                        iziToast.show({
                                                            class: 'ms-progress',
                                                            title: "<?= __('please wait', 'zlink') ?>",
                                                            message: "<?= __('Editing the map...', 'zlink') ?>",
                                                            messageSize: '16px',
                                                            messageLineHeight: '1.8rem',
                                                            titleSize: '18px',
                                                            titleLineHeight: '1.8rem',
                                                            pauseOnHover: true,
                                                            close: false,
                                                            rtl: true,
                                                            position: 'topRight',
                                                            progressBar: true,
                                                            progressBarColor: 'rgb(2, 127, 27)',
                                                            progressBarEasing: 'linear',
                                                            overlay: true,
                                                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                            backgroundColor: '#d6ffde'
                                                        });
                                                    },
                                                    success: function (response) {
                                                        location.reload();
                                                    }
                                                });
                                            });
                                        })(jQuery)
                                    </script>

                                    <?php
                                    // edit widget editAddLink
                                    require(ZLI_PAG . 'widgets/edit/editAddMap.php');

                                }

                                /**
                                 * widget addFaq
                                 */
                                if ($widget['widget_name'] == 'frmFaq') {
                                    $content = json_decode($widget['content'], true);
                                    $widgetId = "addFaq_widget_" . $widget['ID'];
                                    $urlDelete = sprintf('admin.php?page=%s&id=%s&idWidget=%s', $_REQUEST['page'], $lastId, $widget['ID']);
                                    ?>

                                    <div id="addFaq_widget_<?= $widget['ID'] ?>" class="ms-widget-link">

                                        <div class="col-md-12">
                                            <h4 class="col-12 text-center faq_title">
                                                <div class="title-link">
                                                    <?= isset($content['widgetFaq']) && !empty($content['widgetFaq']) ? $content['widgetFaq'] : __('Faq', 'zlink') ?>
                                                </div>
                                            </h4>
                                        </div>

                                        <?php
                                        foreach ($content['question_faq'] as $key_faq => $value_faq):
                                            $question_id_explode = explode('_', $key_faq);
                                            $question_id = end($question_id_explode);
                                            ?>

                                            <div class="accordion accordionZlink" id="accordionZlink">
                                                <div class="template">
                                                    <div class="card" id="template-<?= $widget['ID'] ?>">
                                                        <div class="card-header"
                                                             id="heading-<?= $widget['ID'] ?>-<?= $question_id ?>">
                                                            <h2 class="mb-0">
                                                                <a id="accordion-txt-<?= $widget['ID'] ?>-<?= $question_id ?>"
                                                                   class="collapseZlink" type="button"
                                                                   data-toggle="collapse"
                                                                   data-target="#collapseFaq-<?= $widget['ID'] ?>-<?= $question_id ?>"
                                                                   aria-expanded="true"
                                                                   aria-controls="collapseFaq-<?= $widget['ID'] ?>-<?= $question_id ?>">
                                                                    <?= $value_faq['question'] ?>
                                                                </a>
                                                            </h2>
                                                        </div>

                                                        <div id="collapseFaq-<?= $widget['ID'] ?>-<?= $question_id ?>"
                                                             class="collapse text-right"
                                                             aria-labelledby="heading-<?= $question_id ?>"
                                                             data-parent="#accordionZlink">
                                                            <div class="card-body">
                                                                <?= $value_faq['replay'] ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        <?php endforeach; ?>

                                        <div class="col-12 btn-remove">
                                            <a id="editBlkFaq_<?= $widget['ID'] ?>"
                                               data-widget="<?= $widget['ID']; ?>"
                                               class="btn btn-outline-success btn-sm"
                                               data-izimodal-open="#edit_modal_faq_<?= $widget['ID'] ?>"
                                               data-izimodal-transitionin="fadeInDown">
                                                <i class="fa fa-pencil"></i>
                                            </a>

                                            <a id="removeBlkFaq_<?= $widget['ID'] ?>"
                                               data-widget="<?= $widgetId ?>" class="btn btn-outline-danger btn-sm">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        </div>

                                    </div>


                                    <script>
                                        (function ($) {
                                            // Open Modal Edit addText
                                            let modalID = "#edit_modal_faq_<?= $widget['ID'] ?>";
                                            let modalInput = "#eFrmFaq_<?= $widget['ID'] ?> #modal-body input";

                                            $("#editBlkFaq_<?= $widget['ID'] ?>").click(function () {
                                                let $hash = $("#accordionZlinkEdit-<?= $widget['ID'] ?>").find(".card").length;
                                                let $thisID = $(this).data('widget');
                                                $(modalID).iziModal({
                                                    overlayClose: false,
                                                    onOpening: function () {
                                                        let inputValue = $(modalInput);
                                                        inputValue.focus(function () {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                        }).blur(function () {
                                                            if (inputValue.val()) {
                                                                return inputValue.val();
                                                            } else {
                                                                $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                            }
                                                        });
                                                    }
                                                });


                                                $("#add-edit-faq-" + $thisID).on("click", function (e) {
                                                    e.preventDefault();
                                                    let timer, delay = 500;
                                                    let $template_div = $("#templateEdit-<?= $widget['ID'] ?>");
                                                    let $newPanel = $template_div.clone();
                                                    $newPanel.find(".card-header").attr("id", "heading-<?= $widget['ID'] ?>-" + (++$hash));
                                                    $newPanel.find(".collapseZlink").attr("id", "accordion-txt-edit-<?= $widget['ID'] ?>-" + $hash);
                                                    $newPanel.find(".collapseZlink").attr("data-target", "#collapseFaqEdit-<?= $widget['ID'] ?>-" + $hash);
                                                    $newPanel.find(".collapseZlink").attr("aria-controls", "#collapseFaqEdit-<?= $widget['ID'] ?>-" + $hash);
                                                    $newPanel.find(".collapseZlink").text("<?= __('Question Number ', 'zlink') ?>" + $hash);
                                                    $newPanel.find(".collapse").attr("aria-labelledby", "heading-<?= $widget['ID'] ?>-" + $hash);
                                                    $newPanel.find(".collapse").attr("id", "collapseFaqEdit-<?= $widget['ID'] ?>-" + $hash);
                                                    $newPanel.find(".btn-remove-faq").attr("id", "remove-faq-edit-<?= $widget['ID'] ?>-" + $hash);
                                                    $newPanel.find(".questionZlinkEdit").attr("id", "questionZlinkEdit-" + $hash).attr("name", "questionZlink[" + $hash + "]").val('');
                                                    $newPanel.find(".label-question-edit").attr("for", "questionZlinkEdit-" + $hash);
                                                    $newPanel.find(".label-answer-edit").attr("for", "AnswerTextEdit-" + $hash);
                                                    $newPanel.find(".input-answer-edit").attr("id", "AnswerTextEdit-" + $hash).attr("name", "AnswerText[" + $hash + "]").val('');
                                                    $("#accordionZlinkEdit-<?= $widget['ID'] ?>").append($newPanel.fadeIn());

                                                    $("#questionZlinkEdit-" + $hash).bind('keydown blur change', function () {
                                                        let $this = $(this);
                                                        let $hash_array = $this.attr('id');
                                                        let $thisID = $hash_array.split('-')[1];
                                                        let $input = $('#questionZlinkEdit-' + $hash);
                                                        let $collapse = $('#accordion-txt-edit-<?= $widget['ID'] ?>-' + $hash);
                                                        let $answer = '#AnswerTextEdit-' + $hash;
                                                        clearTimeout(timer);
                                                        timer = setTimeout(function () {
                                                            $collapse.text($input.val());
                                                            if ($input.val() === '') {
                                                                $collapse.text('<?= __('Question Number ', 'zlink') ?>' + $hash);
                                                            }
                                                        }, delay);

                                                        modal_text('#questionZlinkEdit-' + $hash);
                                                        modal_body($answer);
                                                    });

                                                    $("#remove-faq-edit-<?= $widget['ID'] ?>-" + $hash).on('click', function (e) {
                                                        e.preventDefault();
                                                        let $this = $(this).parent().parent();
                                                        $this.parent().remove();
                                                        --$hash;
                                                    });

                                                });

                                                modal_text('#questionZlinkEdit-' + $hash);
                                                modal_body('#AnswerTextEdit-' + $hash);
                                                modal_body('#AnswerTextEdit-' + 1);


                                                $(".btn-remove-faq").on("click", function (e) {
                                                    e.preventDefault();
                                                    let $thisID = $(this).attr("id");
                                                    let $hashRemove = $thisID.split("-");
                                                    let $lastHash = $hashRemove[$hashRemove.length - 1];
                                                    let $divID = $("#remove-faq-edit-<?= $widget['ID'] ?>-" + $lastHash);
                                                    let $parentID = $divID.parent().parent().parent();
                                                    $parentID.remove();
                                                });

                                                function modal_body(id) {
                                                    if ($(id).val() !== '') {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }

                                                    $(id).focus(function () {
                                                        $("label[for='" + this.id + "']").css("transform", "scale(0.75) translateY(-130%)");
                                                    }).blur(function () {
                                                        let inputValue = $(this).val();
                                                        if (inputValue) {
                                                            return inputValue;
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }

                                                function modal_text(id) {
                                                    $(id).focus(function () {
                                                        let $label = $("label[for='" + this.id + "']");
                                                        $label.css("transform", "scale(1) translateY(-25px)");
                                                        $label.css("font-size", "16px");
                                                    }).blur(function () {
                                                        let inputValue = $(this).val();
                                                        if (inputValue) {
                                                            return inputValue;
                                                        } else {
                                                            $("label[for='" + this.id + "']").css("transform", "scale(1) translateY(0)");
                                                        }
                                                    });
                                                }

                                            });

                                            $("#removeBlkFaq_<?= $widget['ID'] ?>").click(function () {
                                                if (getCookie('addFaq') > 0) {
                                                    const widgetRandID = getCookie('addFaq') - 1;
                                                    setCookie('addFaq', widgetRandID, 365);
                                                }
                                                window.location.href = "<?= $urlDelete ?>";
                                            });

                                            /**
                                             * edit ajax data widget faq in database
                                             */
                                            $(document).on('submit', '#eFrmFaq_<?= $widget['ID'] ?>', function (event) {
                                                event.preventDefault();
                                                $.ajax({
                                                    type: "POST",
                                                    dataType: "JSON",
                                                    url: ajax.ajax_url,
                                                    data: $(this).serializeArray(),
                                                    beforeSend: function () {
                                                        $(modalID).iziModal('close');
                                                        iziToast.show({
                                                            class: 'ms-progress',
                                                            title: "<?= __('please wait', 'zlink') ?>",
                                                            message: "<?= __('Editing faq widget ...', 'zlink') ?>",
                                                            messageSize: '16px',
                                                            messageLineHeight: '1.8rem',
                                                            titleSize: '18px',
                                                            titleLineHeight: '1.8rem',
                                                            pauseOnHover: true,
                                                            close: false,
                                                            rtl: true,
                                                            position: 'topRight',
                                                            progressBar: true,
                                                            progressBarColor: 'rgb(2, 127, 27)',
                                                            progressBarEasing: 'linear',
                                                            overlay: true,
                                                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                                                            backgroundColor: '#d6ffde'
                                                        });
                                                    },
                                                    success: function (response) {

                                                    },
                                                    complete: function () {
                                                        location.reload();
                                                    }
                                                });
                                            });
                                        })(jQuery)
                                    </script>

                                    <?php
                                    // edit widget editAddLink
                                    require(ZLI_PAG . 'widgets/edit/editAddFaq.php');

                                }
                                endforeach;
                                else :
                                    ?>
                                    <div class="col-md-12">
                                        <div class="alert alert-warning" role="alert">
                                            <strong><?= __('Please create your own widget', 'zlink') ?></strong>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <script>

                            (function ($) {
                                $(document).ready(function () {
                                    $(".tab-faq-btn").on("click", function (event) {
                                        event.preventDefault();
                                        let sel = this.getAttribute("data-toggle-target");
                                        $(".tab-faq-btn").removeClass("active").filter(sel).addClass("active");
                                        console.log($(this).filter(sel));
                                        $(".tab-faq").removeClass("active").filter(sel).addClass("active");
                                    });
                                });


                            })(jQuery)

                        </script>

                        <span id="spanForm"></span>
                        <a id="addModalOpen" class="btn btn-add" href="#" data-izimodal-open="#addModal"
                           data-izimodal-transitionin="fadeInDown">
                            <?= __('Add a new block', 'zlink') ?>
                        </a>

                        <!-- add block modal -->
                        <?php require_once(ZLI_PAG . 'modal/addBlock_Modal.php'); ?>

                        <!-- add widget link-->
                        <?php require_once(ZLI_PAG . 'widgets/addLink.php'); ?>

                        <!-- add widget contact us -->
                        <?php require_once(ZLI_PAG . 'widgets/contactUs.php'); ?>

                        <!-- add widget messenger -->
                        <?php require_once(ZLI_PAG . 'widgets/messenger.php'); ?>

                        <!-- add widget addText-->
                        <?php require_once(ZLI_PAG . 'widgets/addText.php'); ?>

                        <!-- add widget quickShop-->
                        <?php require_once(ZLI_PAG . 'widgets/quickShop.php'); ?>

                        <!-- add widget eNamad-->
                        <?php require_once(ZLI_PAG . 'widgets/eNamad.php'); ?>

                        <!-- add widget eNamad-->
                        <?php require_once(ZLI_PAG . 'widgets/addMap.php'); ?>

                        <!-- add widget addFaq-->
                        <?php require_once(ZLI_PAG . 'widgets/addFaq.php'); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript">
        (function ($) {
            /**
             * Save ajax data widget link in database
             */
            $(document).on('submit', '#frmLink', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_link').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding useful links widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        let number = parseInt(getCookie('addLink')) + 1;

                        $("input[name='url']").val('');
                        $("input[name='titleLink']").val('');

                        setCookie('addLink', number);

                        location.reload();
                    }
                });
            });


            /**
             * Save ajax data widget contact in database
             */
            $(document).on('submit', '#frmContact', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_contact').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding Contact Widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("input[name='phone']").val('');
                        $("input[name='telephone']").val('');
                        $("input[name='email']").val('');
                        location.reload();
                    }
                });
            });


            /**
             * Save ajax data widget messenger in database
             */
            $(document).on('submit', '#frmMessage', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_messenger').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding messenger widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("input[name='telegram']").val('');
                        $("input[name='whatsapp']").val('');
                        location.reload();
                    }
                });
            });


            /**
             * Save ajax data widget messenger in database
             */
            $(document).on('submit', '#frmText', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_text').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding text / description widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("textarea[name='text']").val('');
                        location.reload();
                    }
                });
            });


            /**
             * Save ajax data widget quickShop in database
             */
            $(document).on('submit', '#frmQuickShop', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_shop').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding Quick Store Widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("input[name='titleShop']").val('');
                        location.reload();
                    }
                });
            });


            /**
             * Save ajax data widget eNamad in database
             */
            $(document).on('submit', '#frmEnamad', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_faq').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Add this eNamad widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("input[name='eNamadUrl']").val('');
                        location.reload();
                    }
                });
            });


            /**
             * Save ajax data widget map in database
             */
            $(document).on('submit', '#frmMap', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serialize(),
                    beforeSend: function () {
                        $('#modal_map').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding Map Widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("input[name='titleMap']").val('');
                        location.reload();
                    }
                });
            });

            /**
             * Save ajax data widget faq in database
             */
            $(document).on('submit', '#frmFaq', function (event) {
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    dataType: "JSON",
                    url: ajax.ajax_url,
                    data: $(this).serializeArray(),
                    beforeSend: function () {
                        $('#modal_faq').iziModal('close');
                        iziToast.show({
                            class: 'ms-progress',
                            title: "<?= __('please wait', 'zlink') ?>",
                            message: "<?= __('Adding Faq Widget ...', 'zlink') ?>",
                            messageSize: '16px',
                            messageLineHeight: '1.8rem',
                            titleSize: '18px',
                            titleLineHeight: '1.8rem',
                            pauseOnHover: true,
                            close: false,
                            rtl: true,
                            position: 'topRight',
                            progressBar: true,
                            progressBarColor: 'rgb(2, 127, 27)',
                            progressBarEasing: 'linear',
                            overlay: true,
                            overlayColor: 'rgba(0, 0, 0, 0.7)',
                            backgroundColor: '#d6ffde',
                        });
                    },
                    success: function (response) {
                        $("input[name='frmFaq']").val('');
                        location.reload();
                    }
                });
            });

        })(jQuery)
    </script>

    <?php unset($_SESSION['alert']); ?>
