<?php

global $wpdb;
$zlink_neshan = $wpdb->prefix . "zlink_neshan";

if (isset($_SESSION['apiID'])) {
    $apiID = $_SESSION['apiID'];
} else {
    $apiID = null;
}

if (!is_null($apiID)) {
    $api_table = $wpdb->get_results("SELECT * FROM {$zlink_neshan} WHERE `ID` = {$apiID} ORDER BY `ID` ASC", ARRAY_A);
} else {
    $api_table = $wpdb->get_results("SELECT * FROM {$zlink_neshan}", ARRAY_A);
}


?>

<div class="container">
    <div class="row mt-5">
        <?php if (isset($api_table) && empty($api_table)) { ?>
            <form action="#" method="post" id="frmAddApi">
                <div class="col-md-12">
                    <h3>
                        <?= __('Settings zlink', 'zlink') ?>
                    </h3>
                    <div class="form-group">
                        <label for="apiKeyNeshan">
                            <?= __('api Enter the badge map', 'zlink') ?>
                        </label>
                        <input name="action" type="hidden" value="addApi">
                        <input id="apiKeyNeshan" name="apiNeshan" type="text" class="form-control"
                               style="text-align: left; direction: ltr;">
                    </div>
                    <a class="text-muted" target="_blank" href="https://platform.neshan.org/">
                        <?= __('Guide to getting the api key from the Neshan website', 'zlink') ?>
                    </a>
                </div>
                <div class="col-md-12 mt-3">
                    <button type="submit" class="btn btn-success">
                        <?= __('Save', 'zlink') ?>
                    </button>
                </div>
            </form>
        <?php } else {
            $apiNeshanID = (isset($api_table) && !empty($api_table)) ? $api_table[0]['ID'] : '';
            $apiNeshan = (isset($api_table) && !empty($api_table)) ? $api_table[0]['ID'] : ''; ?>
            <form action="#" method="post" id="eFrmAddApi">
                <div class="col-md-12">
                    <h3>
                        <?= __('Settings zlink', 'zlink') ?>
                    </h3>


                    <div class="form-group">
                        <label for="apiKeyNeshanEdit">
                            <?= __('api Enter the badge map', 'zlink') ?>
                        </label>
                        <input name="action" type="hidden" value="editApi">
                        <input name="apiID" type="hidden" value="<?= $apiNeshanID ?>">
                        <input id="apiKeyNeshanEdit" name="apiKeyNeshanEdit" type="text" class="form-control"
                               style="text-align: left; direction: ltr;"
                               value="<?= $apiNeshan ?>">
                    </div>
                    <a class="text-muted" target="_blank" href="https://platform.neshan.org/">
                        <?= __('Guide to getting the api key from the Neshan website', 'zlink') ?>
                    </a>
                </div>
                <div class="col-md-12 mt-3">
                    <button type="submit" class="btn btn-success">
                        <?= __('Edit', 'zlink') ?>
                    </button>
                </div>
            </form>
        <?php } ?>
    </div>
</div>

<script>
    (function ($) {
        $(document).on('submit', '#frmAddApi', function (event) {
            event.preventDefault();
            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: ajax.ajax_url,
                data: $(this).serialize(),
                beforeSend: function () {
                    iziToast.show({
                        class: 'ms-progress',
                        title: "<?= __('please wait', 'zlink') ?>",
                        message: "<?= __('Registering the api key ...', 'zlink') ?>",
                        messageSize: '16px',
                        messageLineHeight: '1.8rem',
                        titleSize: '18px',
                        titleLineHeight: '1.8rem',
                        pauseOnHover: true,
                        close: false,
                        rtl: true,
                        position: 'topRight',
                        progressBar: true,
                        progressBarColor: 'rgb(2, 127, 27)',
                        progressBarEasing: 'linear',
                        overlay: true,
                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                        backgroundColor: '#d6ffde'
                    });
                },
                success: function (res) {
                    location.reload();
                }
            });
        });

        $(document).on('submit', '#eFrmAddApi', function (event) {
            event.preventDefault();
            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: ajax.ajax_url,
                data: $(this).serialize(),
                beforeSend: function () {
                    iziToast.show({
                        class: 'ms-progress',
                        title: "<?= __('please wait', 'zlink') ?>",
                        message: "<?= __('Editing the api key neshan...', 'zlink') ?>",
                        messageSize: '16px',
                        messageLineHeight: '1.8rem',
                        titleSize: '18px',
                        titleLineHeight: '1.8rem',
                        pauseOnHover: true,
                        close: false,
                        rtl: true,
                        position: 'topRight',
                        progressBar: true,
                        progressBarColor: 'rgb(2, 127, 27)',
                        progressBarEasing: 'linear',
                        overlay: true,
                        overlayColor: 'rgba(0, 0, 0, 0.7)',
                        backgroundColor: '#d6ffde'
                    });
                },
                success: function (response) {
                    location.reload();
                }
            });
        });
    })(jQuery)
</script>