<div class="modal" id="modal_shop">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?= __('Add a quickShop', 'zlink') ?></h5>
            <a id="closeModal" href="#" class="close" data-izimodal-close="modal_shop"
               data-izimodal-transitionout="bounceOutDown">
                <span aria-hidden="true">&times;</span>
            </a>
        </div>

        <form action="#" method="post" class="frmQuickShop" id="frmQuickShop">
            <div id="modal-body" class="modal-body">
                <div class="title-group form-group">
                    <div class="icon">
                        <i class="fa fa-pencil"></i>
                    </div>
                    <label for="title-shop" class="label-title"><?= __('Title quickShop*', 'zlink') ?></label>
                    <input name="widgetName" type="hidden" value="quickShop">
                    <input name="action" type="hidden" value="addShop">
                    <input name="lastId" type="hidden" value="<?= $lastId ?>">
                    <input id="widgetPriorityShop" name="widgetPriorityShop" type="hidden" value="">
                    <input id="title-shop" type="text" name="titleShop" maxlength="255" size="60"
                           class="form-control">
                </div>


                <div class="title-group-shop form-group">
                    <label for="category" class="label-title"><?= __('products categorization', 'zlink') ?></label>
                    <select id="category" name="category" class="form-select form-select-lg mb-3">
                        <option selected><?= __('Selected', 'zlink') ?></option>
                        <?php foreach ($product_categories as $category) { ?>
                            <option value="<?= $category->term_id ?>"><?= $category->name ?></option>
                        <?php } ?>
                    </select>
                </div>


                <div id="product-tag" class="title-group-shop form-group">
                    <label for="productTag" class="label-title">
                        <?= __('products tags', 'zlink') ?>
                    </label>
                    <select id="productTag" name="productTag" class="form-select form-select-lg mb-3">
                        <option value="" selected><?= __('Selected', 'zlink') ?></option>
                        <?php if (!empty($terms) && !is_wp_error($terms)) { ?>
                            <?php foreach ($terms as $term) { ?>
                                <option value="<?= $term->term_id ?>"><?= $term->name ?></option>
                            <?php } ?>
                        <?php } ?>
                    </select>
                </div>

                <div class="title-group-shop form-group">
                    <label for="countProduct" class="label-title"><?= __('Number of products', 'zlink') ?></label>
                    <select id="countProduct" name="countProduct" class="form-select form-select-lg mb-3">
                        <option value="" selected><?= __('Selected', 'zlink') ?></option>
                        <option value="2">2</option>
                        <option value="4">4</option>
                        <option value="6">6</option>
                        <option value="8">8</option>
                    </select>
                </div>

                <div class="title-group-shop form-group">
                    <label for="numProduct"
                           class="label-title">
                        <?= __('Number of products in each row', 'zlink') ?>
                    </label>
                    <select id="numProduct" name="numProduct" class="form-select form-select-lg mb-3">
                        <option value="" selected><?= __('Selected', 'zlink') ?></option>
                        <option value="12">1</option>
                        <option value="6">2</option>
                    </select>
                </div>

            </div>
            <div class="modal-footer">
                <button type="submit" id="blk-shop" class="btn btn-success add-btn">
                    <?= __('Save', 'zlink') ?>
                </button>
            </div>
        </form>
    </div>
</div>
<script>
    (function ($) {
        $(document).ready(function () {
            if (checkCookie('addShop')) {
                $("#widgetPriorityShop").val(getCookie('addShop'));
            }
        });
    })(jQuery)
</script>

