<?php
global $wpdb, $randID;

$zlink_links = $wpdb->prefix . "zlink_links";
$zlink_widget = $wpdb->prefix . "zlink_widget";
$zlink_neshan = $wpdb->prefix . "zlink_neshan";

$link_table = $wpdb->get_results("SELECT * FROM {$zlink_links} WHERE `id` = {$atts['id']}", ARRAY_A);
$widget_table = $wpdb->get_results("SELECT * FROM {$zlink_widget} WHERE `link_id` = {$atts['id']} ORDER BY `ID` ASC", ARRAY_A);

$api_table = $wpdb->get_results("SELECT * FROM {$zlink_neshan}", ARRAY_A);
$apikey = isset($api_table[0]['apiNeshan']) ? $api_table[0]['apiNeshan'] : '';

$query = array(
    'post_type' => 'product',
    'post_status' => 'publish',
    'ignore_sticky_posts' => 1,
    'posts_per_page' => 6,
    'no_found_rows' => true,
    'meta_query' => [],
    'tax_query' => [],
    'order' => 'ASC'
);

function url()
{
    return get_site_url() . "/";
}

function hasShortcode($value)
{
    $search = ['[', ']'];
    $shortcode = str_replace($search, '', $value);
    $shortcode_array = explode(' ', $shortcode);
    return has_shortcode('[' . $shortcode_array[0] . ']', $shortcode_array[0]);
}

function show_shortcode($value)
{
    $search = ['\"', '\"'];
    $shortcode = str_replace($search, '"', $value);
    return do_shortcode($shortcode);
}

$page_name = $link_table[0]['link_name'];

?>
<div class="row justify-content-center">
    <div class="col-md-4 msf-body">
        <div class="zlink-body">
            <div class="upload-picture">
                <img src="<?= $link_table[0]['images'] ?>">
            </div>

            <div class="title">
                <h4>
                    <?= $link_table[0]['title'] ?>
                </h4>
            </div>

            <div class="description">
                <p><?= $link_table[0]['subtitle'] ?></p>
            </div>

            <?php foreach ($widget_table

            as $widget) : ?>
            <div class="link-show-widget">
                <div id="widgetBlk" class="row field">

                    <?php if ($widget['widget_name'] == 'Link') : ?>
                        <?php $content = json_decode($widget['content'], true); ?>
                        <div class="ms-widget-link">
                            <h4 class="col-12 text-center">
                                <div class="title-link">
                                    <?= $widgetTitle = $content['widgetTitle'] ? $content['widgetTitle'] : __('Useful links', 'zlink'); ?>
                                </div>
                            </h4>
                            <div class="col-12 link">
                                <div class="field__item field_shortcode">
                                    <i class="fa fa-external-link"></i>
                                    <a target="_blank"
                                       href="<?= $content['url'] ?>"><?= $content['titleLink'] ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($widget['widget_name'] == 'contactUs') : ?>
                        <?php $content = json_decode($widget['content'], true); ?>
                        <div class="ms-widget-link">
                            <h4 class="col-12 text-center">
                                <div class="title-link">
                                    <?= $content['widgetTitle'] ? $content['widgetTitle'] : __('Contact Us', 'zlink'); ?>
                                </div>
                            </h4>
                            <div class="col-12 contact">
                                <?php if ($content['phone']) : ?>
                                    <div class="field__item">
                                        <i class="fa fa-mobile"></i>
                                        <a target="_blank"
                                           href="tel:<?= $content['phone'] ?>"><?= $content['phone'] ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($content['telephone']) : ?>
                                    <div class="field__item">
                                        <i class="fa fa-phone"></i>
                                        <a target="_blank"
                                           href="tel:<?= $content['telephone'] ?>"><?= $content['telephone'] ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($content['email']) : ?>
                                    <div class="field__item">
                                        <i class="fa fa-envelope"></i>
                                        <a target="_blank"
                                           href="mailto:<?= $content['email'] ?>"><?= $content['email'] ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($content['fax']) : ?>
                                    <div class="field__item">
                                        <i class="fa fa-fax"></i>
                                        <a target="_blank" href="tel:<?= $content['fax'] ?>"><?= $content['fax'] ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($widget['widget_name'] == 'Message') : ?>
                        <?php $content = json_decode($widget['content'], true); ?>
                        <div class="ms-widget-link message">
                            <h4 class="col-12 text-center">
                                <div class="title-link">
                                    <?= $content['widgetTitle'] ? $content['widgetTitle'] : __('Messenger', 'zlink'); ?>
                                </div>
                            </h4>

                            <div class="col-12">
                                <div class="row justify-content-center">
                                    <?php if ($content['telegram']) : ?>
                                        <div class="col-6 link ms-message ms-telegram">
                                            <div class="field__item">
                                                <a target="_blank"
                                                   href="tg://resolve?domain=@<?= $content['telegram'] ?>">
                                                    <i class="fa fa-mobile"></i>
                                                    <?= __('Telegram', 'zlink') ?>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($content['whatsapp']) : ?>
                                        <div class="col-6 link ms-message ms-whatsapp">
                                            <div class="field__item">
                                                <a target="_blank"
                                                   href="https://api.whatsapp.com/send?phone=<?= $content['whatsapp'] ?>">
                                                    <i class="fa fa-mobile"></i>
                                                    <?= __('whatsapp', 'zlink') ?>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($widget['widget_name'] == 'Description') : ?>
                        <?php $content = json_decode($widget['content'], true); ?>
                        <div class="ms-widget-link">
                            <h4 class="col-12 text-center">
                                <div class="title-link">
                                    <?= $content['widgetTitle'] ? $content['widgetTitle'] : __('Description', 'zlink'); ?>
                                </div>
                            </h4>
                            <div class="col-12 text">
                                <div class="field__item">
                                    <?php if (hasShortcode($content['text'])) { ?>
                                        <?= show_shortcode($content['text']) ?>
                                    <?php } else { ?>
                                        <p><?= $content['text'] ?></p>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($widget['widget_name'] == 'quickShop') : ?>
                    <?php
                    $content = json_decode($widget['content'], true);
                    if ($content['countProduct']) {
                        $query['posts_per_page'] = $content['countProduct'];
                    }

                    if (!isset($content['productTag']) && empty($content['productTag'])) {
                        $query['tax_query'] = [
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $content['category'],
                                'operator' => 'IN',
                            )
                        ];
                    } else {
                        $query['tax_query'] = [
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field' => 'term_id',
                                'terms' => $content['category']
                            ),
                            array(
                                'taxonomy' => 'product_tag',
                                'field' => 'term_id',
                                'terms' => $content['productTag'],
                                'operator' => 'IN',
                            )
                        ];
                    }

                    ?>

                    <h4 class="col-12 text-center">
                        <div class="title-link">
                            <?= $content['titleShop'] ?>
                        </div>
                    </h4>
                    <div class="row ms-quick">
                        <?php
                        $wp_product = new \WP_Query($query);
                        if ($wp_product->have_posts()) {
                        while ($wp_product->have_posts()) :
                        $wp_product->the_post();
                        $products = new \WC_Product(get_the_ID());
                        $regular_price = $products->get_regular_price();
                        $sale_price = $products->get_sale_price();
                        $stock_status = $products->get_stock_status();

                        ?>
                        <?php if ($content['numProduct'] != "") { ?>
                        <div class="col-<?= intval($content['numProduct']) ?> ms-product">
                            <?php } else { ?>
                            <div class="col-6 ms-product">
                                <?php } ?>
                                <?php if ($stock_status === 'instock'): ?>
                                    <a class="link-shop"
                                       href="<?= url() . 'cart/?add-to-cart=' . $products->get_id() ?>"></a>
                                <?php else: ?>
                                    <a class="link-shop"
                                       href="<?= $products->get_permalink() ?>"></a>
                                <?php endif; ?>
                                <div class="quick-shop">
                                    <div class="img-shop">
                                        <?= $products->get_image(); ?>
                                    </div>
                                    <div class="title-pro-shop">
                                        <h5>
                                            <?= $products->get_title(); ?>
                                        </h5>
                                        <?php if ($stock_status === 'instock'): ?>
                                            <div class="price-shop">
                                                <?= $products->get_price_html(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="price-shop outstock-shop">
                                                <p><?= __('unavailable', 'zlink') ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ($stock_status === 'instock'): ?>
                                        <div id="btn-basket-shop" class="btn-basket-shop">
                                            <a href="<?= url() . 'cart/?add-to-cart=' . $products->get_id() ?>"
                                               class="btn btn-outline-success">
                                                <i class="fa fa-basket-shopping"></i>
                                                <?= __('Add to cart', 'zlink') ?>
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div id="btn-basket-shop" class="btn-basket-shop">
                                            <a href="<?= $products->get_permalink() ?>"
                                               class="btn btn-outline-success">
                                                <i class="fa fa-eye"></i>
                                                <?= __('View product', 'zlink') ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php
                            endwhile;
                            wp_reset_postdata();
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <?php endif; ?>

                <?php if ($widget['widget_name'] == 'Map') : ?>
                    <?php $content = json_decode($widget['content'], true); ?>
                    <div class="ms-widget-link">
                        <h4 class="col-12 text-center">
                            <div class="title-link">
                                <?= $content['titleMap'] ?>
                            </div>
                        </h4>
                        <?php if ($apikey) { ?>
                            <div class="col-12 link widgetMap">
                                <div class="map" id="map_<?= $widget['ID'] ?>"
                                     style="width: 100%; height: <?= $content['heightStyleMap'] ?>px;"></div>

                                <a target="_blank" href="<?= $content['urlMap'] ?>"
                                   class="btn btn-outline-success btn-block">
                                    <i class="fa fa-map-location-dot"></i>
                                    <?= __('Direction', 'zlink') ?>
                                </a>
                                <script type="text/javascript">
                                    var myMap = new ol.Map({
                                        target: "map_<?= $widget['ID'] ?>",
                                        key: '<?= $apikey ?>',
                                        maptype: 'dreamy',
                                        poi: true,
                                        traffic: true,
                                        view: new ol.View({
                                            center: ol.proj.fromLonLat([
                                                <?= $content['heightMap'] ?>,
                                                <?= $content['widthMap'] ?>
                                            ]),
                                            zoom: <?= $content['zoomMap'] ?>
                                        })
                                    });

                                    myMap.setMapType("neshan");
                                </script>
                            </div>
                        <?php } else { ?>
                            <div class="alert alert-warning is-dismissible mt-2">
                                <i class="fa fa-info-circle"></i>
                                <?= __('Please enter the Neshan key', 'zlink') ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php endif; ?>

                <?php if ($widget['widget_name'] == 'eNamad') : ?>
                    <?php $content = json_decode($widget['content'], true); ?>
                    <div class="ms-widget-link">
                        <h4 class="col-12 text-center">
                            <div class="title-link">
                                <?= __('eNamad', 'zlink') ?>
                            </div>
                        </h4>

                        <div class="col-12 link">
                            <div class="field__item addWidgetText enamad">
                                <a href="<?= $content['eNamadUrl'] ?>" target="_blank">
                                    <img src="<?= ZLI_URL . 'assets/images/enamad_icon.png' ?>">
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($widget['widget_name'] == 'frmFaq'): ?>
                    <?php
                    $content = json_decode($widget['content'], true);

                    ?>

                    <div class="col-12">
                        <h4 class="col-12 text-center">
                            <div class="title-link">
                                <?= isset($content['widgetFaq']) && !empty($content['widgetFaq']) ? $content['widgetFaq'] : __('Faq', 'zlink') ?>
                            </div>
                        </h4>
                    </div>
                    <div class="col-12 widget-faq link">
                        <?php
                        foreach ($content['question_faq'] as $key_faq => $value_faq):
                            $question_id_explode = explode('_', $key_faq);
                            $question_id = end($question_id_explode);
                            ?>

                            <div class="accordion accordionZlink" id="accordionZlink">
                                <div class="template">
                                    <div class="card">
                                        <div class="card-header" id="heading-<?= $widget['ID'] ?>-<?= $question_id ?>">
                                            <h2 class="mb-0">
                                                <a id="accordion-txt-<?= $widget['ID'] ?>-<?= $question_id ?>"
                                                   class="collapseZlink" type="button"
                                                   data-toggle="collapse"
                                                   data-target="#collapseFaq-<?= $widget['ID'] ?>-<?= $question_id ?>"
                                                   aria-expanded="true"
                                                   aria-controls="collapseFaq-<?= $widget['ID'] ?>-<?= $question_id ?>">
                                                    <?= $value_faq['question'] ?>
                                                </a>
                                            </h2>
                                        </div>

                                        <div id="collapseFaq-<?= $widget['ID'] ?>-<?= $question_id ?>"
                                             class="collapse text-right"
                                             aria-labelledby="heading-<?= $question_id ?>"
                                             data-parent="#accordionZlink">
                                            <div class="card-body">
                                                <?= $value_faq['replay'] ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                <?php endif; ?>

                <?php endforeach; ?>

            </div>
        </div>
