<?php
global $wpdb;
$zlink_links = $wpdb->prefix . "zlink_links";
$link_table = $wpdb->get_results("SELECT * FROM {$zlink_links}", ARRAY_A);

$page_exist = [];
foreach ($link_table as $index => $page_name) {
    $page_exist[$index] = $page_name['link_name'];
}
$isPage = false;
foreach ($page_exist as $pageCheck) {
    if (is_page($pageCheck)) {
        require_once(ZLI_INC . 'frontend.php');
        $isPage = true;
    }
}
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php if (!get_theme_support('title-tag')) : ?>
        <title><?php wp_title(); ?></title>
    <?php endif; ?>

    <?php wp_head(); ?>
</head>

<body <?php body_class('ms-container-body'); ?>>
<?php wp_body_open(); ?>

<?php while (have_posts()) : ?>

    <?php the_post(); ?>
    <div id="ms-container" class="container">
        <?php the_content(); ?>
    </div>
<?php endwhile; ?>

<?php wp_footer(); ?>

</body>
</html>













