<?php
/**
 * Plugin Name: زدلینک
 * Description: به کمک زدلینک همه راههای ارتباطی رو یک جا جمع کنید و پروفایل شخصی خودتون رو بسازید
 * Plugin URI:  http://landing.dominodev.com/zlink
 * Version:     1.3.0
 * Author:      dominodev
 * Author URI:  http://landing.dominodev.com/zlink
 * Text Domain: zlink
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

define('ZLI_DIR', trailingslashit(plugin_dir_path(__FILE__)));
define('ZLI_URL', trailingslashit(plugin_dir_url(__FILE__)));
define('ZLI_NAM', explode('/', plugin_basename(__FILE__)));
define('ZLI_PAG', trailingslashit(ZLI_DIR . 'pages'));
define('ZLI_INC', trailingslashit(ZLI_DIR . 'includes'));
define('ZLI_CNT', trailingslashit(ZLI_DIR . 'controller'));
define('ZLI_TPL', trailingslashit(ZLI_DIR . 'templates'));
define('ZLI_WIG', trailingslashit(ZLI_TPL . 'widgets'));


final class z_link
{
    /**
     * Minimum PHP Version
     *
     * @since 1.2.0
     * @var string Minimum PHP version required to run the plugin.
     */
    const MINIMUM_PHP_VERSION = '7.4';

    private static $_instance = null;

    public function __construct()
    {
        // Check for required PHP version
        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', array($this, 'admin_notice_minimum_php_version'));
            return;
        }

        // Check SSL
        if (!isset($_SERVER['HTTPS'])) {
            add_action('admin_notices', array($this, 'admin_notice_ssl'));
        }

        // Load translation
        add_action('init', array($this, 'i18n'));

        // Session start init
        add_action('init', array($this, 'register_my_session'));

        // obStart init
        add_action('init', array($this, 'register_obStart'));

        // installer table in db wp
        add_action('init', array($this, 'installer'));

        // save session in the wp
//        add_action('init', array($this, 'save_session_callback'));

        // add shortcode zlink
        add_shortcode('zlink', array($this, 'short_show_zlink'));

        // add Template Zlink in wp
        require_once(ZLI_TPL . 'functions.php');
        add_action('plugins_loaded', 'zlink_bootstrap');

        if (is_admin() && !class_exists('iLink_zlink')) {
            require_once(ZLI_CNT . 'iLink-zlink.php');
        }

        if (is_admin()) {
            require_once(ZLI_INC . 'backend.php');
        }

    }

    public function short_show_zlink($atts)
    {
        require_once(ZLI_TPL . "template-shortcode.php");
    }


    public function pt_add_page_template_to_dropdown($templates)
    {
        $templates[plugin_dir_path(__FILE__) . 'templates/tmpl.php'] = __('Template zlink', 'zlink');
        return $templates;
    }

    public function pt_change_page_template($template)
    {
        if (is_page()) {
            $meta = get_post_meta(get_the_ID());

            if (!empty($meta['_wp_page_template'][0]) && $meta['_wp_page_template'][0] != $template) {
                $template = $meta['_wp_page_template'][0];
            }
        }

        return $template;
    }


    public function save_session_callback()
    {
        if (isset($_SESSION['randID'])) {
            set_transient('count_widget', $_SESSION['randID']);
        }

        if ($_SESSION['randID'] === 1) {
            $current_session = get_transient('count_widget');
            $_SESSION['randID'] = $current_session;
        }
    }

    /**
     * Admin notice
     *
     * Warning when the site doesn't have a minimum required PHP version.
     *
     * @since 1.0.0
     * @access public
     */

    public function admin_notice_minimum_php_version()
    {
        $message = sprintf(
        /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
            esc_html__('"%1$s" requires "%2$s" version %3$s or greater.', 'zlink'),
            '<strong>' . esc_html__('zlink', 'zlink') . '</strong>',
            '<strong>' . esc_html__('PHP', 'zlink') . '</strong>',
            self::MINIMUM_PHP_VERSION
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function admin_notice_ssl()
    {
        $class = 'notice notice-warning is-dismissible';
        $message = __('Advice! SSL is not enabled on your website. For better Instagram trust in your link, please enable SSL.', 'zlink');

        printf('<div class="%1$s"><p><strong>%2$s</strong></p></div>', esc_attr($class), esc_html($message));
    }


    /**
     * Load Textdomain
     *
     * Load plugin localization files.
     * Fired by `init` action hook.
     *
     * @since 1.0.0
     * @access public
     */

    public function i18n()
    {
        load_plugin_textdomain('zlink', false, dirname(plugin_basename(__FILE__)) . '/languages/');
    }


    /**
     * add session start init wp
     */
    public function register_my_session()
    {
        if (!session_id()) {
            session_start();
        }
    }

    public function register_obStart()
    {
        ob_start();
    }

    /**
     * @return z_link|null
     */
    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    /**
     * Create database activation plugin
     *
     * @since 1.0.0
     * @access public
     */
    public function installer()
    {
        require_once(ZLI_INC . 'installer.php');
    }
}

z_link::instance();